/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaBasePluginRules;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.component.external.model.JavaEcosystemVariantDerivationStrategy;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    @Incubating
    public static final String COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY = "org.gradle.java.compile-classpath-packaging";
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = ImmutableSet.of((Object)"java-classes-directory", (Object)"java-resources-directory", (Object)"directory");
    private final ObjectFactory objectFactory;
    private final boolean javaClasspathPackaging;

    @Inject
    public JavaBasePlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.javaClasspathPackaging = Boolean.getBoolean(COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY);
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaPluginConvention javaConvention = this.addExtensions(project);
        this.configureSourceSetDefaults(javaConvention);
        this.configureCompileDefaults(project, javaConvention);
        this.configureJavaDoc(project, javaConvention);
        this.configureTest(project, javaConvention);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.configureSchema(project);
        this.bridgeToSoftwareModelIfNecessary(project);
        this.configureVariantDerivationStrategy(project);
    }

    private void configureVariantDerivationStrategy(ProjectInternal project) {
        ComponentMetadataHandlerInternal metadataHandler = (ComponentMetadataHandlerInternal)((Object)project.getDependencies().getComponents());
        metadataHandler.setVariantDerivationStrategy(new JavaEcosystemVariantDerivationStrategy());
    }

    private JavaPluginConvention addExtensions(ProjectInternal project) {
        DefaultJavaPluginConvention javaConvention = new DefaultJavaPluginConvention(project, this.objectFactory);
        project.getConvention().getPlugins().put("java", javaConvention);
        project.getExtensions().add(SourceSetContainer.class, "sourceSets", ((JavaPluginConvention)javaConvention).getSourceSets());
        project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, javaConvention, project);
        return javaConvention;
    }

    private void bridgeToSoftwareModelIfNecessary(ProjectInternal project) {
        project.addRuleBasedPluginListener(new RuleBasedPluginListener(){

            @Override
            public void prepareForRuleBasedPlugins(Project project) {
                project.getPluginManager().apply(JavaBasePluginRules.class);
            }
        });
    }

    private void configureSchema(ProjectInternal project) {
        AttributesSchema attributesSchema = project.getDependencies().getAttributesSchema();
        JavaEcosystemSupport.configureSchema(attributesSchema, this.objectFactory);
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime")).attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, "jar"));
    }

    private void configureSourceSetDefaults(final JavaPluginConvention pluginConvention) {
        final ProjectInternal project = pluginConvention.getProject();
        pluginConvention.getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                ConventionMapping outputConventionMapping = ((IConventionAware)((Object)sourceSet.getOutput())).getConventionMapping();
                ConfigurationContainer configurations = project.getConfigurations();
                JavaBasePlugin.this.defineConfigurationsForSourceSet(sourceSet, configurations, pluginConvention);
                JavaBasePlugin.this.definePathsForSourceSet(sourceSet, outputConventionMapping, project);
                JavaBasePlugin.this.createProcessResourcesTask(sourceSet, sourceSet.getResources(), project);
                TaskProvider compileTask = JavaBasePlugin.this.createCompileJavaTask(sourceSet, sourceSet.getJava(), project);
                JavaBasePlugin.this.createClassesTask(sourceSet, project);
                JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, sourceSet.getJava(), project, compileTask, compileTask.map(new Transformer<CompileOptions, JavaCompile>(){

                    @Override
                    public CompileOptions transform(JavaCompile javaCompile) {
                        return javaCompile.getOptions();
                    }
                }));
            }
        });
    }

    private TaskProvider<JavaCompile> createCompileJavaTask(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, final Project target) {
        return target.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, new Action<JavaCompile>(){

            @Override
            public void execute(JavaCompile compileTask) {
                compileTask.setDescription("Compiles " + sourceDirectorySet + ".");
                compileTask.setSource(sourceDirectorySet);
                ConventionMapping conventionMapping = compileTask.getConventionMapping();
                conventionMapping.map("classpath", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return sourceSet.getCompileClasspath();
                    }
                });
                JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, compileTask.getOptions(), target);
            }
        });
    }

    private void createProcessResourcesTask(final SourceSet sourceSet, final SourceDirectorySet resourceSet, Project target) {
        target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, new Action<ProcessResources>(){

            @Override
            public void execute(ProcessResources resourcesTask) {
                resourcesTask.setDescription("Processes " + resourceSet + ".");
                new DslObject(resourcesTask.getRootSpec()).getConventionMapping().map("destinationDir", new Callable<File>(){

                    @Override
                    public File call() {
                        return sourceSet.getOutput().getResourcesDir();
                    }
                });
                resourcesTask.from(resourceSet);
            }
        });
    }

    private void createClassesTask(final SourceSet sourceSet, Project target) {
        NamedDomainObjectProvider classesTask = target.getTasks().register(sourceSet.getClassesTaskName(), new Action<Task>(){

            @Override
            public void execute(Task classesTask) {
                classesTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
                classesTask.dependsOn(sourceSet.getOutput().getDirs());
                classesTask.dependsOn(sourceSet.getCompileJavaTaskName());
                classesTask.dependsOn(sourceSet.getProcessResourcesTaskName());
            }
        });
        sourceSet.compiledBy(classesTask);
    }

    private void definePathsForSourceSet(final SourceSet sourceSet, ConventionMapping outputConventionMapping, final Project project) {
        outputConventionMapping.map("resourcesDir", new Callable<Object>(){

            @Override
            public Object call() {
                String classesDirName = "resources/" + sourceSet.getName();
                return new File(project.getBuildDir(), classesDirName);
            }
        });
        sourceSet.getJava().srcDir("src/" + sourceSet.getName() + "/java");
        sourceSet.getResources().srcDir("src/" + sourceSet.getName() + "/resources");
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations, JavaPluginConvention convention) {
        String compileConfigurationName = sourceSet.getCompileConfigurationName();
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeConfigurationName = sourceSet.getRuntimeConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
        String runtimeElementsConfigurationName = sourceSet.getRuntimeElementsConfigurationName();
        String sourceSetName = sourceSet.toString();
        Action<ConfigurationInternal> configureDefaultTargetPlatform = this.configureDefaultTargetPlatform(convention);
        DeprecatableConfiguration compileConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(compileConfigurationName);
        compileConfiguration.setVisible(false);
        compileConfiguration.setDescription("Dependencies for " + sourceSetName + " (deprecated, use '" + implementationConfigurationName + "' instead).");
        Configuration implementationConfiguration = (Configuration)configurations.maybeCreate(implementationConfigurationName);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        implementationConfiguration.setCanBeConsumed(false);
        implementationConfiguration.setCanBeResolved(false);
        implementationConfiguration.extendsFrom(compileConfiguration);
        DeprecatableConfiguration runtimeConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(runtimeConfigurationName);
        runtimeConfiguration.setVisible(false);
        runtimeConfiguration.extendsFrom(compileConfiguration);
        runtimeConfiguration.setDescription("Runtime dependencies for " + sourceSetName + " (deprecated, use '" + runtimeOnlyConfigurationName + "' instead).");
        DeprecatableConfiguration compileOnlyConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(compileOnlyConfigurationName);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        ConfigurationInternal compileClasspathConfiguration = (ConfigurationInternal)configurations.maybeCreate(compileClasspathConfigurationName);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(compileOnlyConfiguration, implementationConfiguration);
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        compileClasspathConfiguration.setCanBeConsumed(false);
        compileClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api"));
        compileClasspathConfiguration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, this.javaClasspathPackaging ? "jar" : "classes"));
        compileClasspathConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, this.objectFactory.named(Bundling.class, "external"));
        compileClasspathConfiguration.beforeLocking(configureDefaultTargetPlatform);
        DeprecatableConfiguration annotationProcessorConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(annotationProcessorConfigurationName);
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
        annotationProcessorConfiguration.setCanBeConsumed(false);
        annotationProcessorConfiguration.setCanBeResolved(true);
        Configuration runtimeOnlyConfiguration = (Configuration)configurations.maybeCreate(runtimeOnlyConfigurationName);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setCanBeConsumed(false);
        runtimeOnlyConfiguration.setCanBeResolved(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        ConfigurationInternal runtimeClasspathConfiguration = (ConfigurationInternal)configurations.maybeCreate(runtimeClasspathConfigurationName);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setCanBeConsumed(false);
        runtimeClasspathConfiguration.setCanBeResolved(true);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(runtimeOnlyConfiguration, runtimeConfiguration, implementationConfiguration);
        runtimeClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"));
        runtimeClasspathConfiguration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, "jar"));
        runtimeClasspathConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, this.objectFactory.named(Bundling.class, "external"));
        runtimeClasspathConfiguration.beforeLocking(configureDefaultTargetPlatform);
        sourceSet.setCompileClasspath(compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus(runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath(annotationProcessorConfiguration);
        compileConfiguration.deprecateForDeclaration(implementationConfigurationName);
        compileConfiguration.deprecateForConsumption(apiElementsConfigurationName);
        compileConfiguration.deprecateForResolution(compileClasspathConfigurationName);
        compileOnlyConfiguration.deprecateForConsumption(apiElementsConfigurationName);
        compileOnlyConfiguration.deprecateForResolution(compileClasspathConfigurationName);
        runtimeConfiguration.deprecateForDeclaration(runtimeOnlyConfigurationName);
        runtimeConfiguration.deprecateForConsumption(runtimeElementsConfigurationName);
        runtimeConfiguration.deprecateForResolution(runtimeClasspathConfigurationName);
        compileClasspathConfiguration.deprecateForDeclaration(implementationConfigurationName, compileOnlyConfigurationName);
        runtimeClasspathConfiguration.deprecateForDeclaration(implementationConfigurationName, compileOnlyConfigurationName, runtimeOnlyConfigurationName);
    }

    private Action<ConfigurationInternal> configureDefaultTargetPlatform(final JavaPluginConvention convention) {
        return new Action<ConfigurationInternal>(){

            @Override
            public void execute(ConfigurationInternal conf) {
                if (!convention.getAutoTargetJvmDisabled()) {
                    JavaEcosystemSupport.configureDefaultTargetPlatform(conf, convention.getTargetCompatibility());
                }
            }
        };
    }

    private void configureCompileDefaults(Project project, final JavaPluginConvention javaConvention) {
        project.getTasks().withType(AbstractCompile.class).configureEach(new Action<AbstractCompile>(){

            @Override
            public void execute(AbstractCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("sourceCompatibility", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return javaConvention.getSourceCompatibility().toString();
                    }
                });
                conventionMapping.map("targetCompatibility", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return javaConvention.getTargetCompatibility().toString();
                    }
                });
            }
        });
    }

    private void configureJavaDoc(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class).configureEach(new Action<Javadoc>(){

            @Override
            public void execute(Javadoc javadoc) {
                javadoc.getConventionMapping().map("destinationDir", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return new File(convention.getDocsDir(), "javadoc");
                    }
                });
                javadoc.getConventionMapping().map("title", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
            }
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, new Action<Task>(){

            @Override
            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
                buildTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                buildTask.dependsOn(JavaBasePlugin.BUILD_TASK_NAME);
            }
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, new Action<Task>(){

            @Override
            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
                buildTask.setGroup(JavaBasePlugin.BUILD_TASK_NAME);
                buildTask.dependsOn(JavaBasePlugin.BUILD_TASK_NAME);
                buildTask.doFirst((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        if (!task.getProject().getGradle().getIncludedBuilds().isEmpty()) {
                            task.getProject().getLogger().warn("[composite-build] Warning: `" + task.getPath() + "` task does not build included builds.");
                        }
                    }
                });
            }
        });
    }

    private void configureTest(Project project, JavaPluginConvention convention) {
        project.getTasks().withType(Test.class).configureEach(test -> this.configureTestDefaults((Test)test, project, convention));
    }

    private void configureTestDefaults(Test test, Project project, JavaPluginConvention convention) {
        DirectoryReport htmlReport = test.getReports().getHtml();
        JUnitXmlReport xmlReport = test.getReports().getJunitXml();
        xmlReport.getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestResultsDir(), test.getName()).getAbsolutePath())));
        htmlReport.getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestReportDir(), test.getName()).getAbsolutePath())));
        test.getBinaryResultsDirectory().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> new File(convention.getTestResultsDir(), test.getName() + "/binary").getAbsolutePath())));
        test.workingDir(project.getProjectDir());
    }
}

