/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaPlugin
implements Plugin<ProjectInternal> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    @Deprecated
    public static final String COMPILE_CONFIGURATION_NAME = "compile";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    @Deprecated
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    @Incubating
    public static final String JAVADOC_ELEMENTS_CONFIGURATION_NAME = "javadocElements";
    @Incubating
    public static final String SOURCES_ELEMENTS_CONFIGURATION_NAME = "sourcesElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    @Deprecated
    public static final String TEST_COMPILE_CONFIGURATION_NAME = "testCompile";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_CONFIGURATION_NAME = "testRuntime";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private final ObjectFactory objectFactory;
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory, SoftwareComponentFactory softwareComponentFactory) {
        this.objectFactory = objectFactory;
        this.softwareComponentFactory = softwareComponentFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        if (project.getPluginManager().hasPlugin("java-platform")) {
            throw new IllegalStateException("The \"java\" or \"java-library\" plugin cannot be applied together with the \"java-platform\" plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = project.getConvention().getPlugin(JavaPluginConvention.class);
        project.getServices().get(ComponentRegistry.class).setMainComponent(new BuildableJavaComponentImpl(javaConvention));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = project.getServices().get(BuildOutputCleanupRegistry.class);
        this.configureSourceSets(javaConvention, buildOutputCleanupRegistry);
        this.configureConfigurations(project, javaConvention);
        this.configureTest(project, javaConvention);
        this.configureJavadocTask(project, javaConvention);
        this.configureArchivesAndComponent(project, javaConvention);
        this.configureBuild(project);
    }

    private void configureSourceSets(JavaPluginConvention pluginConvention, final BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().create("main");
        SourceSet test = (SourceSet)pluginConvention.getSourceSets().create(TEST_TASK_NAME);
        test.setCompileClasspath(project.getObjects().fileCollection().from(main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)));
        test.setRuntimeClasspath(project.getObjects().fileCollection().from(test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)));
        pluginConvention.getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                buildOutputCleanupRegistry.registerOutputs(sourceSet.getOutput());
            }
        });
    }

    private void configureArchivesAndComponent(Project project, final JavaPluginConvention pluginConvention) {
        NamedDomainObjectProvider jar = project.getTasks().register(JAR_TASK_NAME, Jar.class, new Action<Jar>(){

            @Override
            public void execute(Jar jar) {
                jar.setDescription("Assembles a jar archive containing the main classes.");
                jar.setGroup("build");
                jar.from(((SourceSet)pluginConvention.getSourceSets().getByName("main")).getOutput());
            }
        });
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(jar);
        Configuration apiElementConfiguration = project.getConfigurations().getByName(API_ELEMENTS_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(jarArtifact);
        NamedDomainObjectProvider processResources = project.getTasks().named(PROCESS_RESOURCES_TASK_NAME, ProcessResources.class);
        this.addJar(apiElementConfiguration, jarArtifact);
        this.addJar(runtimeConfiguration, jarArtifact);
        this.addRuntimeVariants(project, runtimeElementsConfiguration, jarArtifact, (SourceSet)pluginConvention.getSourceSets().getByName("main"), processResources);
        this.registerSoftwareComponents(project);
    }

    private void configureJavadocTask(ProjectInternal project, JavaPluginConvention pluginConvention) {
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().getByName("main");
        JvmPluginsHelper.configureJavaDocTask(null, main, project.getTasks());
    }

    private void registerSoftwareComponents(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        AdhocComponentWithVariants java = this.softwareComponentFactory.adhoc("java");
        java.addVariantsFromConfiguration(configurations.getByName(API_ELEMENTS_CONFIGURATION_NAME), new JavaConfigurationVariantMapping(COMPILE_CONFIGURATION_NAME, false));
        java.addVariantsFromConfiguration(configurations.getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME), new JavaConfigurationVariantMapping(RUNTIME_CONFIGURATION_NAME, false));
        project.getComponents().add(java);
    }

    private void addJar(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add(jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, JAR_TASK_NAME);
    }

    private void addRuntimeVariants(Project project, Configuration configuration, PublishArtifact jarArtifact, SourceSet sourceSet, final Provider<ProcessResources> processResources) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add(jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, JAR_TASK_NAME);
        JvmPluginsHelper.configureClassesDirectoryVariant(sourceSet, project, sourceSet.getRuntimeElementsConfigurationName(), "java-runtime");
        NamedDomainObjectContainer<ConfigurationVariant> runtimeVariants = publications.getVariants();
        ConfigurationVariant resourcesVariant = runtimeVariants.create("resources");
        resourcesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"));
        resourcesVariant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, "resources"));
        resourcesVariant.artifact(new JvmPluginsHelper.IntermediateJavaArtifact("java-resources-directory", processResources){

            @Override
            public File getFile() {
                return ((ProcessResources)processResources.get()).getDestinationDir();
            }
        });
    }

    private void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", new Action<Task>(){

            @Override
            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
        project.getTasks().named("buildDependents", new Action<Task>(){

            @Override
            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, false, "buildDependents", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
    }

    private void configureTest(Project project, final JavaPluginConvention pluginConvention) {
        project.getTasks().withType(Test.class).configureEach(new Action<Test>(){

            @Override
            public void execute(Test test) {
                test.getConventionMapping().map("testClassesDirs", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getOutput().getClassesDirs();
                    }
                });
                test.getConventionMapping().map("classpath", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getRuntimeClasspath();
                    }
                });
            }
        });
        final NamedDomainObjectProvider test = project.getTasks().register(TEST_TASK_NAME, Test.class, new Action<Test>(){

            @Override
            public void execute(Test test) {
                test.setDescription("Runs the unit tests.");
                test.setGroup("verification");
            }
        });
        project.getTasks().named("check", new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.dependsOn(test);
            }
        });
    }

    private void configureConfigurations(Project project, JavaPluginConvention convention) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration compileConfiguration = configurations.getByName(COMPILE_CONFIGURATION_NAME);
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurations.getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        Configuration compileTestsConfiguration = configurations.getByName(TEST_COMPILE_CONFIGURATION_NAME);
        Configuration testImplementationConfiguration = configurations.getByName(TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration testRuntimeConfiguration = configurations.getByName(TEST_RUNTIME_CONFIGURATION_NAME);
        Configuration testRuntimeOnlyConfiguration = configurations.getByName(TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        compileTestsConfiguration.extendsFrom(compileConfiguration);
        testImplementationConfiguration.extendsFrom(implementationConfiguration);
        testRuntimeConfiguration.extendsFrom(runtimeConfiguration);
        testRuntimeOnlyConfiguration.extendsFrom(runtimeOnlyConfiguration);
        DeprecatableConfiguration apiElementsConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(API_ELEMENTS_CONFIGURATION_NAME);
        apiElementsConfiguration.setVisible(false);
        apiElementsConfiguration.setDescription("API elements for main.");
        apiElementsConfiguration.setCanBeResolved(false);
        apiElementsConfiguration.setCanBeConsumed(true);
        apiElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api"));
        apiElementsConfiguration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, JAR_TASK_NAME));
        apiElementsConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, this.objectFactory.named(Bundling.class, "external"));
        apiElementsConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, this.objectFactory.named(Category.class, "library"));
        apiElementsConfiguration.extendsFrom(runtimeConfiguration);
        DeprecatableConfiguration runtimeElementsConfiguration = (DeprecatableConfiguration)configurations.maybeCreate(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        runtimeElementsConfiguration.setVisible(false);
        runtimeElementsConfiguration.setCanBeConsumed(true);
        runtimeElementsConfiguration.setCanBeResolved(false);
        runtimeElementsConfiguration.setDescription("Elements of runtime for main.");
        runtimeElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"));
        runtimeElementsConfiguration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, JAR_TASK_NAME));
        runtimeElementsConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, this.objectFactory.named(Bundling.class, "external"));
        runtimeElementsConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, this.objectFactory.named(Category.class, "library"));
        runtimeElementsConfiguration.extendsFrom(implementationConfiguration, runtimeOnlyConfiguration, runtimeConfiguration);
        defaultConfiguration.extendsFrom(runtimeElementsConfiguration);
        apiElementsConfiguration.deprecateForDeclaration(IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME);
        runtimeElementsConfiguration.deprecateForDeclaration(IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME, RUNTIME_ONLY_CONFIGURATION_NAME);
        this.configureTargetPlatform(apiElementsConfiguration, convention);
        this.configureTargetPlatform(runtimeElementsConfiguration, convention);
    }

    private void configureTargetPlatform(Configuration outgoing, final JavaPluginConvention convention) {
        ((ConfigurationInternal)outgoing).beforeLocking((Action<? super ConfigurationInternal>)new Action<ConfigurationInternal>(){

            @Override
            public void execute(ConfigurationInternal configuration) {
                JavaEcosystemSupport.configureDefaultTargetPlatform(configuration, convention.getTargetCompatibility());
            }
        });
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName));
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final JavaPluginConvention convention;

        public BuildableJavaComponentImpl(JavaPluginConvention convention) {
            this.convention = convention;
        }

        @Override
        public Collection<String> getBuildTasks() {
            return Collections.singleton("build");
        }

        @Override
        public FileCollection getRuntimeClasspath() {
            ProjectInternal project = this.convention.getProject();
            SourceSet mainSourceSet = (SourceSet)this.convention.getSourceSets().getByName("main");
            FileCollection runtimeClasspath = mainSourceSet.getRuntimeClasspath();
            Configuration gradleApi = project.getConfigurations().detachedConfiguration(project.getDependencies().gradleApi(), project.getDependencies().localGroovy());
            Configuration runtimeElements = project.getConfigurations().getByName(mainSourceSet.getRuntimeElementsConfigurationName());
            FileCollection mainSourceSetArtifact = runtimeElements.getOutgoing().getArtifacts().getFiles();
            return mainSourceSetArtifact.plus(runtimeClasspath.minus(mainSourceSet.getOutput()).minus(gradleApi));
        }

        @Override
        public Configuration getCompileDependencies() {
            return this.convention.getProject().getConfigurations().getByName(JavaPlugin.COMPILE_CLASSPATH_CONFIGURATION_NAME);
        }
    }
}

