/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.AntlrSourceVirtualDirectoryImpl;
import org.gradle.api.tasks.SourceSet;

public class AntlrPlugin
implements Plugin<Project> {
    public static final String ANTLR_CONFIGURATION_NAME = "antlr";
    private final ObjectFactory objectFactory;

    @Inject
    public AntlrPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        Configuration antlrConfiguration = ((Configuration)project.getConfigurations().create(ANTLR_CONFIGURATION_NAME)).setVisible(false).setDescription("The Antlr libraries to be used for this project.");
        antlrConfiguration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(project.getDependencies().create("antlr:antlr:2.7.7@jar"));
            }
        });
        project.getConfigurations().getByName("compile").extendsFrom(antlrConfiguration);
        project.getTasks().withType(AntlrTask.class).configureEach(new Action<AntlrTask>(){

            @Override
            public void execute(AntlrTask antlrTask) {
                antlrTask.getConventionMapping().map("antlrClasspath", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return project.getConfigurations().getByName(AntlrPlugin.ANTLR_CONFIGURATION_NAME);
                    }
                });
            }
        });
        project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(final SourceSet sourceSet) {
                final AntlrSourceVirtualDirectoryImpl antlrDirectoryDelegate = new AntlrSourceVirtualDirectoryImpl(((DefaultSourceSet)sourceSet).getDisplayName(), AntlrPlugin.this.objectFactory);
                new DslObject(sourceSet).getConvention().getPlugins().put(AntlrPlugin.ANTLR_CONFIGURATION_NAME, antlrDirectoryDelegate);
                String srcDir = "src/" + sourceSet.getName() + "/antlr";
                antlrDirectoryDelegate.getAntlr().srcDir(srcDir);
                sourceSet.getAllSource().source(antlrDirectoryDelegate.getAntlr());
                final String taskName = sourceSet.getTaskName("generate", "GrammarSource");
                String outputDirectoryName = project.getBuildDir() + "/generated-src/antlr/" + sourceSet.getName();
                final File outputDirectory = new File(outputDirectoryName);
                sourceSet.getJava().srcDir(outputDirectory);
                project.getTasks().register(taskName, AntlrTask.class, new Action<AntlrTask>(){

                    @Override
                    public void execute(AntlrTask antlrTask) {
                        antlrTask.setDescription("Processes the " + sourceSet.getName() + " Antlr grammars.");
                        antlrTask.setSource(antlrDirectoryDelegate.getAntlr());
                        antlrTask.setOutputDirectory(outputDirectory);
                    }
                });
                project.getTasks().named(sourceSet.getCompileJavaTaskName(), new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        task.dependsOn(taskName);
                    }
                });
            }
        });
    }
}

