/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents.internal;

import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.reporting.dependents.internal.DependentComponentsGraphRenderer;
import org.gradle.api.reporting.dependents.internal.DependentComponentsRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;
import org.gradle.reporting.ReportRenderer;

public class DependentComponentsRenderer
extends ReportRenderer<ComponentSpec, TextReportBuilder> {
    private final DependentBinariesResolver resolver;
    private final boolean showNonBuildable;
    private final boolean showTestSuites;
    private boolean seenTestSuite;
    private boolean hiddenTestSuite;
    private boolean hiddenNonBuildable;

    public DependentComponentsRenderer(@Nullable DependentBinariesResolver dependentBinariesResolver, boolean showNonBuildable, boolean showTestSuites) {
        this.resolver = dependentBinariesResolver;
        this.showNonBuildable = showNonBuildable;
        this.showTestSuites = showTestSuites;
    }

    @Override
    public void render(final ComponentSpec component, TextReportBuilder builder) {
        ComponentSpecInternal internalProtocol = (ComponentSpecInternal)((Object)component);
        DependentComponentsRenderableDependency root = this.getRenderableDependencyOf(component, internalProtocol);
        if (!this.showNonBuildable && !root.isBuildable()) {
            this.hiddenNonBuildable = true;
            return;
        }
        StyledTextOutput output = builder.getOutput();
        GraphRenderer renderer = new GraphRenderer(output);
        renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text(component.getName());
                output.withStyle(StyledTextOutput.Style.Description).text(" - Components that depend on " + component.getDisplayName());
            }
        }, true);
        DependentComponentsGraphRenderer dependentsGraphRenderer = new DependentComponentsGraphRenderer(renderer, this.showNonBuildable, this.showTestSuites);
        if (root.getChildren().isEmpty()) {
            output.withStyle(StyledTextOutput.Style.Info).text("No dependents");
            output.println();
        } else {
            dependentsGraphRenderer.render(root);
            output.println();
        }
        if (dependentsGraphRenderer.hasSeenTestSuite()) {
            this.seenTestSuite = true;
        }
        if (dependentsGraphRenderer.hasHiddenTestSuite()) {
            this.hiddenTestSuite = true;
        }
        if (dependentsGraphRenderer.hasHiddenNonBuildable()) {
            this.hiddenNonBuildable = true;
        }
    }

    private DependentComponentsRenderableDependency getRenderableDependencyOf(ComponentSpec componentSpec, ComponentSpecInternal internalProtocol) {
        if (this.resolver != null && componentSpec instanceof VariantComponentSpec) {
            VariantComponentSpec variantComponentSpec = (VariantComponentSpec)componentSpec;
            LinkedHashSet children = Sets.newLinkedHashSet();
            for (BinarySpecInternal binarySpec : variantComponentSpec.getBinaries().withType(BinarySpecInternal.class)) {
                DependentBinariesResolutionResult resolvedBinary = this.resolver.resolve(binarySpec);
                children.add(DependentComponentsRenderableDependency.of(resolvedBinary.getRoot()));
            }
            return DependentComponentsRenderableDependency.of(componentSpec, internalProtocol, children);
        }
        return DependentComponentsRenderableDependency.of(componentSpec, internalProtocol);
    }

    public void printLegend(TextReportBuilder builder) {
        if (this.seenTestSuite || this.hiddenTestSuite || this.hiddenNonBuildable) {
            StyledTextOutput output = builder.getOutput();
            if (this.seenTestSuite) {
                output.withStyle(StyledTextOutput.Style.Info).println("(t) - Test suite binary");
                if (this.hiddenNonBuildable) {
                    output.println();
                }
            } else if (this.hiddenTestSuite) {
                output.withStyle(StyledTextOutput.Style.Info).println("Some test suites were not shown, use --test-suites or --all to show them.");
            }
            if (this.hiddenNonBuildable) {
                output.withStyle(StyledTextOutput.Style.Info).println("Some non-buildable components were not shown, use --non-buildable or --all to show them.");
            }
        }
    }
}

