/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;

public class BuildCacheCommandFactory {
    private final BuildCacheEntryPacker packer;
    private final OriginMetadataFactory originMetadataFactory;
    private final VirtualFileSystem virtualFileSystem;
    private final Interner<String> stringInterner;

    public BuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, VirtualFileSystem virtualFileSystem, Interner<String> stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.virtualFileSystem = virtualFileSystem;
        this.stringInterner = stringInterner;
    }

    public BuildCacheLoadCommand<LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity) {
        return new LoadCommand(cacheKey, entity);
    }

    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
        return new StoreCommand(cacheKey, entity, fingerprints, executionTime);
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, CurrentFileCollectionFingerprint> fingerprints;
        private final long executionTime;

        private StoreCommand(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.fingerprints = fingerprints;
            this.executionTime = executionTime;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            BuildCacheEntryPacker.PackResult packResult = BuildCacheCommandFactory.this.packer.pack(this.entity, this.fingerprints, output, BuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, this.executionTime));
            return packResult::getEntries;
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;

        private LoadCommand(BuildCacheKey cacheKey, CacheableEntity entity) {
            this.cacheKey = cacheKey;
            this.entity = entity;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<LoadMetadata> load(InputStream input) throws IOException {
            ImmutableList.Builder roots = ImmutableList.builder();
            this.entity.visitOutputTrees((name, type, root) -> roots.add((Object)root.getAbsolutePath()));
            BuildCacheCommandFactory.this.virtualFileSystem.update((Iterable<String>)roots.build(), () -> {});
            final BuildCacheEntryPacker.UnpackResult unpackResult = BuildCacheCommandFactory.this.packer.unpack(this.entity, input, BuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
            final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshots = this.snapshotUnpackedData(unpackResult.getSnapshots());
            return new BuildCacheLoadCommand.Result<LoadMetadata>(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public LoadMetadata getMetadata() {
                    return new LoadMetadata(){

                        @Override
                        public OriginMetadata getOriginMetadata() {
                            return unpackResult.getOriginMetadata();
                        }

                        @Override
                        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots() {
                            return snapshots;
                        }
                    };
                }
            };
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotUnpackedData(Map<String, ? extends CompleteFileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            FingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            this.entity.visitOutputTrees((treeName, type, root) -> {
                CompleteFileSystemLocationSnapshot treeSnapshot = (CompleteFileSystemLocationSnapshot)treeSnapshots.get(treeName);
                String internedAbsolutePath = (String)BuildCacheCommandFactory.this.stringInterner.intern((Object)root.getAbsolutePath());
                ArrayList<CompleteFileSystemLocationSnapshot> roots = new ArrayList<CompleteFileSystemLocationSnapshot>();
                if (treeSnapshot == null) {
                    MissingFileSnapshot missingFileSnapshot = new MissingFileSnapshot(internedAbsolutePath);
                    BuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot(missingFileSnapshot);
                    builder.put((Object)treeName, (Object)fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                switch (type) {
                    case FILE: {
                        if (treeSnapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{treeName, treeSnapshot.getType()}));
                        }
                        roots.add(treeSnapshot);
                        BuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot(treeSnapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(treeSnapshot);
                        BuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot(treeSnapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                builder.put((Object)treeName, (Object)DefaultCurrentFileCollectionFingerprint.from(roots, fingerprintingStrategy));
            });
            return builder.build();
        }
    }

    public static interface LoadMetadata {
        public OriginMetadata getOriginMetadata();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots();
    }
}

