/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public class OriginMetadata {
    private final String buildInvocationId;
    private final long executionTime;

    public OriginMetadata(String buildInvocationId, long executionTime) {
        this.buildInvocationId = (String)Preconditions.checkNotNull((Object)buildInvocationId, (Object)"buildInvocationId");
        this.executionTime = executionTime;
    }

    public String getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginMetadata that = (OriginMetadata)o;
        return this.executionTime == that.executionTime && this.buildInvocationId.equals(that.buildInvocationId);
    }

    public int hashCode() {
        int result = this.buildInvocationId.hashCode();
        result = 31 * result + (int)(this.executionTime ^ this.executionTime >>> 32);
        return result;
    }

    public String toString() {
        return "OriginMetadata{buildInvocationId=" + this.buildInvocationId + ", executionTime=" + this.executionTime + '}';
    }
}

