/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.File;
import java.io.IOException;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;

public class PackerDirectoryUtil {
    public static void ensureDirectoryForTree(Deleter deleter, TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                deleter.ensureEmptyDirectory(root);
                break;
            }
            case FILE: {
                if (PackerDirectoryUtil.makeDirectory(deleter, root.getParentFile()) || !root.exists()) break;
                deleter.deleteRecursively(root);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static boolean makeDirectory(Deleter deleter, File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            deleter.delete(target);
        }
        FileUtils.forceMkdir((File)target);
        return true;
    }
}

