/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.DefaultNestedBuild;
import org.gradle.composite.internal.DefaultRootBuildState;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements BuildStateRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ListenerManager listenerManager;
    private final BuildTreeScopeServices rootServices;
    private RootBuildState rootBuild;
    private final Map<BuildIdentifier, BuildState> buildsByIdentifier = Maps.newHashMap();
    private final Map<File, IncludedBuildState> includedBuildsByRootDir = Maps.newLinkedHashMap();
    private final Map<Path, File> includedBuildDirectoriesByPath = Maps.newLinkedHashMap();
    private final Deque<IncludedBuildState> pendingIncludedBuilds = new ArrayDeque<IncludedBuildState>();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, BuildTreeScopeServices rootServices) {
        this.includedBuildFactory = includedBuildFactory;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.listenerManager = listenerManager;
        this.rootServices = rootServices;
    }

    @Override
    public RootBuildState getRootBuild() {
        if (this.rootBuild == null) {
            throw new IllegalStateException("Root build is not defined.");
        }
        return this.rootBuild;
    }

    @Override
    public RootBuildState createRootBuild(BuildDefinition buildDefinition) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = new DefaultRootBuildState(buildDefinition, this.gradleLauncherFactory, this.listenerManager, this.rootServices);
        this.addBuild(this.rootBuild);
        return this.rootBuild;
    }

    @Override
    public void attachRootBuild(RootBuildState rootBuild) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = rootBuild;
        this.addBuild(rootBuild);
    }

    private void addBuild(BuildState build) {
        BuildState before = this.buildsByIdentifier.put(build.getBuildIdentifier(), build);
        if (before != null) {
            throw new IllegalArgumentException("Build is already registered: " + build.getBuildIdentifier());
        }
    }

    public boolean hasIncludedBuilds() {
        return !this.includedBuildsByRootDir.isEmpty();
    }

    public Collection<IncludedBuildState> getIncludedBuilds() {
        return this.includedBuildsByRootDir.values();
    }

    @Override
    public IncludedBuildState addIncludedBuild(BuildDefinition buildDefinition) {
        return this.registerBuild(buildDefinition, false);
    }

    @Override
    public IncludedBuildState getIncludedBuild(BuildIdentifier buildIdentifier) {
        BuildState includedBuildState = this.buildsByIdentifier.get(buildIdentifier);
        if (!(includedBuildState instanceof IncludedBuildState)) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return (IncludedBuildState)includedBuildState;
    }

    @Override
    public BuildState getBuild(BuildIdentifier buildIdentifier) {
        BuildState buildState = this.buildsByIdentifier.get(buildIdentifier);
        if (buildState == null) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return buildState;
    }

    @Override
    public void beforeConfigureRootBuild() {
        this.registerSubstitutions(this.includedBuildsByRootDir.values());
    }

    @Override
    public void finalizeIncludedBuilds() {
        SettingsInternal rootSettings = this.getRootBuild().getLoadedSettings();
        while (!this.pendingIncludedBuilds.isEmpty()) {
            IncludedBuildState build = this.pendingIncludedBuilds.removeFirst();
            SettingsInternal includedBuildSettings = build.loadSettings();
            String includedBuildRootProjectName = includedBuildSettings.getRootProject().getName();
            if (!rootSettings.getRootProject().getName().equals(includedBuildRootProjectName)) continue;
            throw new GradleException("Included build in " + build.getRootDirectory() + " has the same root project name '" + includedBuildRootProjectName + "' as the main build.");
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuildState> includedBuilds) {
        for (IncludedBuildState includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build(includedBuild);
        }
    }

    @Override
    public synchronized IncludedBuildState addImplicitIncludedBuild(BuildDefinition buildDefinition) {
        IncludedBuildState includedBuild = this.includedBuildsByRootDir.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, true);
        }
        return includedBuild;
    }

    @Override
    public StandAloneNestedBuild addBuildSrcNestedBuild(BuildDefinition buildDefinition, BuildState owner) {
        if (!"buildSrc".equals(buildDefinition.getName())) {
            throw new IllegalStateException("Expected buildSrc build, got: " + buildDefinition.getName());
        }
        Path identityPath = this.assignPath(owner, buildDefinition.getName(), buildDefinition.getBuildRootDir());
        BuildIdentifier buildIdentifier = this.idFor(buildDefinition.getName());
        DefaultNestedBuild build = new DefaultNestedBuild(buildIdentifier, identityPath, buildDefinition, owner);
        this.addBuild(build);
        return build;
    }

    @Override
    public NestedRootBuild addNestedBuildTree(BuildDefinition buildDefinition, BuildState owner, String buildName) {
        if (buildDefinition.getName() != null || buildDefinition.getBuildRootDir() != null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        File dir = buildDefinition.getStartParameter().getCurrentDir();
        String name = (String)MoreObjects.firstNonNull((Object)buildName, (Object)dir.getName());
        this.validateNameIsNotBuildSrc(name, dir);
        Path identityPath = this.assignPath(owner, name, dir);
        BuildIdentifier buildIdentifier = this.idFor(name);
        return new RootOfNestedBuildTree(buildDefinition, buildIdentifier, identityPath, owner);
    }

    private void validateNameIsNotBuildSrc(String name, File dir) {
        if ("buildSrc".equals(name)) {
            throw new GradleException("Included build " + dir + " has build name 'buildSrc' which cannot be used as it is a reserved name.");
        }
    }

    private IncludedBuildState registerBuild(BuildDefinition buildDefinition, boolean isImplicit) {
        File buildDir = buildDefinition.getBuildRootDir();
        if (buildDir == null) {
            throw new IllegalArgumentException("Included build must have a root directory defined");
        }
        if (this.rootBuild == null) {
            throw new IllegalStateException("No root build attached yet.");
        }
        IncludedBuildState includedBuild = this.includedBuildsByRootDir.get(buildDir);
        if (includedBuild == null) {
            String buildName = buildDefinition.getName();
            if (buildName == null) {
                throw new IllegalStateException("build name is required");
            }
            this.validateNameIsNotBuildSrc(buildName, buildDir);
            Path idPath = this.assignPath(this.rootBuild, buildDefinition.getName(), buildDir);
            BuildIdentifier buildIdentifier = this.idFor(buildName);
            includedBuild = this.includedBuildFactory.createBuild(buildIdentifier, idPath, buildDefinition, isImplicit, this.rootBuild);
            this.includedBuildsByRootDir.put(buildDir, includedBuild);
            this.pendingIncludedBuilds.add(includedBuild);
            this.addBuild(includedBuild);
        } else if (includedBuild.isImplicitBuild() != isImplicit) {
            throw new IllegalStateException("Unexpected state for build.");
        }
        return includedBuild;
    }

    private BuildIdentifier idFor(String buildName) {
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(buildName);
        int count = 1;
        while (this.buildsByIdentifier.containsKey(buildIdentifier)) {
            buildIdentifier = new DefaultBuildIdentifier(buildName + ":" + count);
            ++count;
        }
        return buildIdentifier;
    }

    private Path assignPath(BuildState owner, String name, File dir) {
        Path requestedPath = owner.getIdentityPath().append(Path.path(name));
        File existingForPath = this.includedBuildDirectoriesByPath.putIfAbsent(requestedPath, dir);
        if (existingForPath != null) {
            throw new GradleException("Included build " + dir + " has build path " + requestedPath + " which is the same as included build " + existingForPath);
        }
        SettingsInternal rootSettings = this.getRootBuild().getLoadedSettings();
        if (rootSettings.findProject(":" + name) != null) {
            throw new GradleException("Included build in " + dir + " has name '" + name + "' which is the same as a project of the main build.");
        }
        return requestedPath;
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.buildsByIdentifier.values()).stop();
    }
}

