/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.internal.resource.EmptyFileTextResource;
import org.gradle.internal.resource.TextResource;
import org.gradle.util.DeprecationLogger;

public class DeprecateUndefinedBuildWorkExecutor
implements BuildWorkExecutor {
    private final BuildWorkExecutor delegate;

    public DeprecateUndefinedBuildWorkExecutor(BuildWorkExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(GradleInternal gradle, Collection<? super Throwable> failures) {
        if (DeprecateUndefinedBuildWorkExecutor.isUndefinedBuild(gradle) && !DeprecateUndefinedBuildWorkExecutor.wasInitTaskRequested(gradle.getStartParameter())) {
            DeprecationLogger.nagUserOfDiscontinuedInvocation("Executing Gradle tasks as part of an undefined build");
        }
        this.delegate.execute(gradle, failures);
    }

    private static boolean isUndefinedBuild(GradleInternal gradle) {
        return !DeprecateUndefinedBuildWorkExecutor.isBuildSrcExecution(gradle) && !gradle.getRootProject().getBuildFile().exists() && DeprecateUndefinedBuildWorkExecutor.isUndefinedResource(gradle.getSettings().getSettingsScript().getResource());
    }

    private static boolean isUndefinedResource(TextResource settingsScript) {
        return settingsScript instanceof EmptyFileTextResource && settingsScript.getFile() == null;
    }

    private static boolean wasInitTaskRequested(StartParameter startParameter) {
        return startParameter.getTaskNames().contains("init");
    }

    private static boolean isBuildSrcExecution(GradleInternal gradle) {
        return gradle.getRootProject().getName().equals("buildSrc") && gradle.getParent() != null;
    }
}

