/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configuration.ScriptTarget;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.plugin.use.internal.PluginUseScriptBlockMetadataCompiler;

public class InitialPassStatementTransformer
implements StatementTransformer {
    public static final String PLUGINS = "plugins";
    public static final String PLUGIN_MANAGEMENT = "pluginManagement";
    private final ScriptTarget scriptTarget;
    private final List<String> scriptBlockNames;
    private final DocumentationRegistry documentationRegistry;
    private final PluginUseScriptBlockMetadataCompiler pluginBlockMetadataCompiler;
    private boolean seenNonClasspathStatement;
    private boolean seenPluginsBlock;
    private int pluginsBlockLineNumber = 0;
    private boolean seenPluginManagementBlock;
    private boolean seenClasspathBlock;

    public InitialPassStatementTransformer(ScriptTarget scriptTarget, DocumentationRegistry documentationRegistry) {
        this.scriptTarget = scriptTarget;
        this.scriptBlockNames = Arrays.asList(scriptTarget.getClasspathBlockName(), PLUGINS, PLUGIN_MANAGEMENT);
        this.documentationRegistry = documentationRegistry;
        this.pluginBlockMetadataCompiler = new PluginUseScriptBlockMetadataCompiler(documentationRegistry);
    }

    @Override
    public Statement transform(SourceUnit sourceUnit, Statement statement) {
        ScriptBlock scriptBlock = AstUtils.detectScriptBlock(statement, this.scriptBlockNames);
        if (scriptBlock == null) {
            this.seenNonClasspathStatement = true;
            return null;
        }
        if (scriptBlock.getName().equals(PLUGINS)) {
            return this.transformPluginsBlock(scriptBlock, sourceUnit, statement);
        }
        if (scriptBlock.getName().equals(PLUGIN_MANAGEMENT)) {
            return this.transformPluginManagementBlock(sourceUnit, statement);
        }
        if (this.seenPluginsBlock) {
            String message = String.format(this.pluginBlockMetadataCompiler.formatErrorMessage("all %s {} blocks must appear before any %s {} blocks in the script"), this.scriptTarget.getClasspathBlockName(), PLUGINS);
            this.addSyntaxError(message, sourceUnit, statement);
        }
        this.seenClasspathBlock = true;
        return statement;
    }

    private Statement transformPluginsBlock(ScriptBlock scriptBlock, SourceUnit sourceUnit, Statement statement) {
        String failMessage = null;
        if (!this.scriptTarget.getSupportsPluginsBlock()) {
            failMessage = this.pluginBlockMetadataCompiler.formatErrorMessage("Only Project and Settings build scripts can contain plugins {} blocks");
        } else {
            this.seenPluginsBlock = true;
            this.addLineNumberToMethodCall(scriptBlock);
            if (this.seenNonClasspathStatement) {
                failMessage = String.format(this.pluginBlockMetadataCompiler.formatErrorMessage("only %s {} and other %s {} script blocks are allowed before %s {} blocks, no other statements are allowed"), this.scriptTarget.getClasspathBlockName(), PLUGINS, PLUGINS);
            } else {
                this.pluginBlockMetadataCompiler.compile(sourceUnit, scriptBlock);
            }
        }
        if (failMessage != null) {
            this.addSyntaxError(failMessage, sourceUnit, statement);
        }
        return statement;
    }

    private void addLineNumberToMethodCall(ScriptBlock scriptBlock) {
        ConstantExpression lineNumberExpression = new ConstantExpression((Object)scriptBlock.getClosureExpression().getLineNumber(), true);
        scriptBlock.getMethodCall().setArguments((Expression)new ArgumentListExpression((Expression)lineNumberExpression, (Expression)scriptBlock.getClosureExpression()));
    }

    private Statement transformPluginManagementBlock(SourceUnit sourceUnit, Statement statement) {
        String failureMessage = this.failureMessageForPluginManagementBlock();
        if (failureMessage != null) {
            this.addSyntaxError(this.makePluginManagementError(failureMessage), sourceUnit, statement);
        }
        this.seenPluginManagementBlock = true;
        return statement;
    }

    private void addSyntaxError(String errorMessage, SourceUnit sourceUnit, Statement statement) {
        sourceUnit.getErrorCollector().addError(new SyntaxException(errorMessage, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
    }

    @Nullable
    private String failureMessageForPluginManagementBlock() {
        if (!this.scriptTarget.getSupportsPluginManagementBlock()) {
            return "Only Settings scripts can contain a pluginManagement {} block.";
        }
        if (this.seenClasspathBlock || this.seenNonClasspathStatement || this.seenPluginsBlock) {
            return String.format("The %s {} block must appear before any other statements in the script.", PLUGIN_MANAGEMENT);
        }
        if (this.seenPluginManagementBlock) {
            return String.format("At most, one %s {} block may appear in the script.", PLUGIN_MANAGEMENT);
        }
        return null;
    }

    private String makePluginManagementError(String failureMessage) {
        return String.format("%s%n%nSee %s for information on the pluginManagement {} block%n%n", failureMessage, this.documentationRegistry.getDocumentationFor(PLUGINS, "sec:plugin_management"));
    }
}

