/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioRootExtension;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.CppApplicationVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.CppSharedLibraryVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.CppStaticLibraryVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioRootExtension;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioSolutionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.ide.visualstudio.plugins.VisualStudioPluginRules;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;

public class VisualStudioPlugin
extends IdePlugin {
    private static final String LIFECYCLE_TASK_NAME = "visualStudio";
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final IdeArtifactRegistry artifactRegistry;
    private CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public VisualStudioPlugin(Instantiator instantiator, FileResolver fileResolver, IdeArtifactRegistry artifactRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.artifactRegistry = artifactRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    @Override
    protected String getLifecycleTaskName() {
        return LIFECYCLE_TASK_NAME;
    }

    @Override
    protected void onApply(Project target) {
        VisualStudioExtensionInternal extension;
        this.project.getPluginManager().apply(LifecycleBasePlugin.class);
        if (this.isRoot()) {
            extension = this.project.getExtensions().create(VisualStudioRootExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioRootExtension.class, this.project.getName(), this.instantiator, target.getObjects(), this.fileResolver, this.artifactRegistry, this.collectionCallbackActionDecorator, this.project.getProviders());
            VisualStudioSolution solution = ((VisualStudioRootExtension)((Object)extension)).getSolution();
            this.getLifecycleTask().configure(it -> it.dependsOn(solution));
            this.addWorkspace(solution);
        } else {
            extension = this.project.getExtensions().create(VisualStudioExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioExtension.class, this.instantiator, this.fileResolver, this.artifactRegistry, this.collectionCallbackActionDecorator, this.project.getProviders());
            this.getLifecycleTask().configure(it -> it.dependsOn(extension.getProjects()));
        }
        this.includeBuildFileInProject(extension);
        this.createTasksForVisualStudio(extension);
        this.applyVisualStudioCurrentModelRules(extension);
        this.applyVisualStudioSoftwareModelRules();
    }

    private void applyVisualStudioCurrentModelRules(VisualStudioExtensionInternal extension) {
        this.project.getComponents().withType(CppApplication.class).all(cppApplication -> {
            DefaultVisualStudioProject vsProject = extension.getProjectRegistry().createProject(this.project.getName(), cppApplication.getName());
            vsProject.getSourceFiles().from(cppApplication.getCppSource());
            vsProject.getHeaderFiles().from(cppApplication.getHeaderFiles());
            cppApplication.getBinaries().whenElementFinalized(CppExecutable.class, executable -> extension.getProjectRegistry().addProjectConfiguration(new CppApplicationVisualStudioTargetBinary(this.project.getName(), this.project.getPath(), (CppComponent)cppApplication, (CppExecutable)executable, this.project.getLayout())));
        });
        this.project.afterEvaluate(proj -> this.project.getComponents().withType(CppLibrary.class).all(cppLibrary -> {
            for (Linkage linkage : (Set)cppLibrary.getLinkage().get()) {
                VisualStudioTargetBinary.ProjectType projectType = VisualStudioTargetBinary.ProjectType.DLL;
                if (Linkage.STATIC.equals(linkage)) {
                    projectType = VisualStudioTargetBinary.ProjectType.LIB;
                }
                DefaultVisualStudioProject vsProject = extension.getProjectRegistry().createProject(this.project.getName() + projectType.getSuffix(), cppLibrary.getName());
                vsProject.getSourceFiles().from(cppLibrary.getCppSource());
                vsProject.getHeaderFiles().from(cppLibrary.getHeaderFiles());
            }
            cppLibrary.getBinaries().whenElementFinalized(CppSharedLibrary.class, library -> extension.getProjectRegistry().addProjectConfiguration(new CppSharedLibraryVisualStudioTargetBinary(this.project.getName(), this.project.getPath(), (CppComponent)cppLibrary, (CppSharedLibrary)library, this.project.getLayout())));
            cppLibrary.getBinaries().whenElementFinalized(CppStaticLibrary.class, library -> extension.getProjectRegistry().addProjectConfiguration(new CppStaticLibraryVisualStudioTargetBinary(this.project.getName(), this.project.getPath(), (CppComponent)cppLibrary, (CppStaticLibrary)library, this.project.getLayout())));
        }));
    }

    private void applyVisualStudioSoftwareModelRules() {
        this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioExtensionRules.class);
        if (this.isRoot()) {
            this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioPluginRootRules.class);
        }
        this.project.getPlugins().withType(ComponentModelBasePlugin.class).all(it -> this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioPluginProjectRules.class));
    }

    private void includeBuildFileInProject(VisualStudioExtensionInternal extension) {
        extension.getProjectRegistry().all(vsProject -> {
            if (this.project.getBuildFile() != null) {
                vsProject.addSourceFile(this.project.getBuildFile());
            }
        });
    }

    private void createTasksForVisualStudio(VisualStudioExtensionInternal extension) {
        extension.getProjectRegistry().all(vsProject -> this.addTasksForVisualStudioProject((VisualStudioProjectInternal)vsProject));
        if (this.isRoot()) {
            VisualStudioRootExtension rootExtension = (VisualStudioRootExtension)((Object)extension);
            VisualStudioSolutionInternal vsSolution = (VisualStudioSolutionInternal)rootExtension.getSolution();
            vsSolution.builtBy(this.createSolutionTask(vsSolution));
        }
        this.configureCleanTask();
    }

    private void addTasksForVisualStudioProject(VisualStudioProjectInternal vsProject) {
        vsProject.builtBy(this.createProjectsFileTask(vsProject), this.createFiltersFileTask(vsProject));
        Task lifecycleTask = (Task)this.project.getTasks().maybeCreate(vsProject.getComponentName() + "VisualStudio");
        lifecycleTask.dependsOn(vsProject);
    }

    private void configureCleanTask() {
        TaskProvider<? extends Task> cleanTask = this.getCleanTask();
        cleanTask.configure(it -> {
            it.delete(this.project.getTasks().withType(GenerateSolutionFileTask.class));
            it.delete(this.project.getTasks().withType(GenerateFiltersFileTask.class));
            it.delete(this.project.getTasks().withType(GenerateProjectFileTask.class));
        });
    }

    private Task createSolutionTask(VisualStudioSolution solution) {
        GenerateSolutionFileTask solutionFileTask = (GenerateSolutionFileTask)this.project.getTasks().create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
        solutionFileTask.setVisualStudioSolution(solution);
        return solutionFileTask;
    }

    private Task createProjectsFileTask(VisualStudioProject vsProject) {
        GenerateProjectFileTask task = (GenerateProjectFileTask)this.project.getTasks().create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
        task.setVisualStudioProject(vsProject);
        task.initGradleCommand();
        return task;
    }

    private Task createFiltersFileTask(VisualStudioProject vsProject) {
        GenerateFiltersFileTask task = (GenerateFiltersFileTask)this.project.getTasks().create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
        task.setVisualStudioProject(vsProject);
        return task;
    }
}

