/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Collections;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.SettingsFactory;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatingSettingsProcessor
implements SettingsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptEvaluatingSettingsProcessor.class);
    private final SettingsFactory settingsFactory;
    private final IGradlePropertiesLoader propertiesLoader;
    private final ScriptPluginFactory configurerFactory;
    private final TextFileResourceLoader textFileResourceLoader;

    public ScriptEvaluatingSettingsProcessor(ScriptPluginFactory configurerFactory, SettingsFactory settingsFactory, IGradlePropertiesLoader propertiesLoader, TextFileResourceLoader textFileResourceLoader) {
        this.configurerFactory = configurerFactory;
        this.settingsFactory = settingsFactory;
        this.propertiesLoader = propertiesLoader;
        this.textFileResourceLoader = textFileResourceLoader;
    }

    @Override
    public SettingsInternal process(GradleInternal gradle, SettingsLocation settingsLocation, ClassLoaderScope baseClassLoaderScope, StartParameter startParameter) {
        Timer settingsProcessingClock = Time.startTimer();
        Map<String, String> properties = this.propertiesLoader.mergeProperties(Collections.emptyMap());
        TextResourceScriptSource settingsScript = new TextResourceScriptSource(this.textFileResourceLoader.loadFile("settings file", settingsLocation.getSettingsFile()));
        SettingsInternal settings = this.settingsFactory.createSettings(gradle, settingsLocation.getSettingsDir(), settingsScript, properties, startParameter, baseClassLoaderScope);
        gradle.getBuildListenerBroadcaster().beforeSettings(settings);
        this.applySettingsScript(settingsScript, settings);
        LOGGER.debug("Timing: Processing settings took: {}", (Object)settingsProcessingClock.getElapsed());
        return settings;
    }

    private void applySettingsScript(TextResourceScriptSource settingsScript, SettingsInternal settings) {
        ScriptPlugin configurer = this.configurerFactory.create(settingsScript, settings.getBuildscript(), settings.getClassLoaderScope(), settings.getBaseClassLoaderScope(), true);
        configurer.apply(settings);
    }
}

