/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.BuildResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.logging.format.DurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.time.Clock;
import org.gradle.util.SingleMessageLogger;

public class BuildResultLogger {
    private final StyledTextOutputFactory textOutputFactory;
    private final BuildStartedTime buildStartedTime;
    private final DurationFormatter durationFormatter;
    private final Clock clock;

    public BuildResultLogger(StyledTextOutputFactory textOutputFactory, BuildStartedTime buildStartedTime, Clock clock, DurationFormatter durationFormatter) {
        this.textOutputFactory = textOutputFactory;
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.durationFormatter = durationFormatter;
    }

    public void buildFinished(BuildResult result) {
        SingleMessageLogger.reportSuppressedDeprecations();
        boolean buildSucceeded = result.getFailure() == null;
        StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, buildSucceeded ? LogLevel.LIFECYCLE : LogLevel.ERROR);
        textOutput.println();
        String action = result.getAction().toUpperCase();
        if (buildSucceeded) {
            textOutput.withStyle(StyledTextOutput.Style.SuccessHeader).text(action + " SUCCESSFUL");
        } else {
            textOutput.withStyle(StyledTextOutput.Style.FailureHeader).text(action + " FAILED");
        }
        long buildDurationMillis = this.clock.getCurrentTime() - this.buildStartedTime.getStartTime();
        textOutput.formatln(" in %s", this.durationFormatter.format(buildDurationMillis));
    }
}

