/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractVariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class RealisedVariantBackedConfigurationMetadata
extends AbstractVariantBackedConfigurationMetadata {
    public RealisedVariantBackedConfigurationMetadata(ModuleComponentIdentifier id, ComponentVariant variant, ImmutableAttributes componentLevelAttributes, ImmutableAttributesFactory attributesFactory) {
        super(id, new ComponentAttributesAwareVariant(variant, attributesFactory, componentLevelAttributes), (List<? extends ModuleDependencyMetadata>)((AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl)variant).getDependencyMetadata());
    }

    private static class ComponentAttributesAwareVariant
    implements ComponentVariant {
        private final ImmutableAttributesFactory attributesFactory;
        private final ComponentVariant delegate;
        private final ImmutableAttributes componentLevelAttributes;
        private ImmutableAttributes computedAttributes;

        ComponentAttributesAwareVariant(ComponentVariant delegate, ImmutableAttributesFactory attributesFactory, ImmutableAttributes componentLevelAttributes) {
            this.attributesFactory = attributesFactory;
            this.delegate = delegate;
            this.componentLevelAttributes = componentLevelAttributes;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public DisplayName asDescribable() {
            return this.delegate.asDescribable();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            if (this.computedAttributes == null) {
                this.computedAttributes = this.mergeComponentAndVariantAttributes(this.delegate.getAttributes());
            }
            return this.computedAttributes;
        }

        @Override
        public ImmutableList<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.delegate.getArtifacts();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.DependencyConstraint> getDependencyConstraints() {
            return this.delegate.getDependencyConstraints();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.delegate.getFiles();
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.delegate.getCapabilities();
        }

        private ImmutableAttributes mergeComponentAndVariantAttributes(AttributeContainerInternal variantAttributes) {
            return this.attributesFactory.concat(this.componentLevelAttributes, variantAttributes.asImmutable());
        }
    }
}

