/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Objects;
import org.gradle.api.internal.attributes.CompatibilityCheckResult;

public class DefaultCompatibilityCheckResult<T>
implements CompatibilityCheckResult<T> {
    private final T consumerValue;
    private final T producerValue;
    private boolean compatible;
    private boolean done;

    public DefaultCompatibilityCheckResult(T consumerValue, T producerValue) {
        assert (producerValue != null) : "Internal contract of the current implementation, can be changed with a motivation";
        assert (!Objects.equals(consumerValue, producerValue));
        this.consumerValue = consumerValue;
        this.producerValue = producerValue;
    }

    @Override
    public boolean isCompatible() {
        assert (this.done);
        return this.compatible;
    }

    @Override
    public boolean hasResult() {
        return this.done;
    }

    @Override
    public T getConsumerValue() {
        return this.consumerValue;
    }

    @Override
    public T getProducerValue() {
        return this.producerValue;
    }

    @Override
    public void compatible() {
        this.done = true;
        this.compatible = true;
    }

    @Override
    public void incompatible() {
        this.done = true;
        this.compatible = false;
    }
}

