/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

@ThreadSafe
public class ScriptUsageLocationReporter
implements ScriptExecutionListener,
UsageLocationReporter {
    private final Lock lock = new ReentrantLock();
    private final Map<String, ScriptSource> scripts = new HashMap<String, ScriptSource>();

    @Override
    public void scriptClassLoaded(ScriptSource scriptSource, Class<? extends Script> scriptClass) {
        this.lock.lock();
        try {
            this.scripts.put(scriptSource.getFileName(), scriptSource);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reportLocation(FeatureUsage usage, StringBuilder target) {
        this.lock.lock();
        try {
            this.doReportLocation(usage, target);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doReportLocation(FeatureUsage usage, StringBuilder target) {
        int caller;
        List<StackTraceElement> stack = usage.getStack();
        if (stack.isEmpty()) {
            return;
        }
        StackTraceElement directCaller = stack.get(0);
        if (this.scripts.containsKey(directCaller.getFileName())) {
            this.reportStackTraceElement(directCaller, target);
            return;
        }
        for (caller = 1; caller < stack.size() && stack.get(caller).getClassName().equals(directCaller.getClassName()); ++caller) {
        }
        if (caller == stack.size()) {
            return;
        }
        StackTraceElement indirectCaller = stack.get(caller);
        if (this.scripts.containsKey(indirectCaller.getFileName())) {
            this.reportStackTraceElement(indirectCaller, target);
        }
    }

    private void reportStackTraceElement(StackTraceElement stackTraceElement, StringBuilder target) {
        ScriptSource scriptSource = this.scripts.get(stackTraceElement.getFileName());
        target.append(StringUtils.capitalize((String)scriptSource.getDisplayName()));
        if (stackTraceElement.getLineNumber() > 0) {
            target.append(": line ");
            target.append(stackTraceElement.getLineNumber());
        }
    }
}

