/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class IgnoredPathFileSystemLocationFingerprint
implements FileSystemLocationFingerprint {
    public static final IgnoredPathFileSystemLocationFingerprint DIRECTORY = new IgnoredPathFileSystemLocationFingerprint(FileType.Directory, DIR_SIGNATURE);
    private static final IgnoredPathFileSystemLocationFingerprint MISSING_FILE = new IgnoredPathFileSystemLocationFingerprint(FileType.Missing, MISSING_FILE_SIGNATURE);
    private final FileType type;
    private final HashCode normalizedContentHash;

    public static IgnoredPathFileSystemLocationFingerprint create(FileType type, HashCode contentHash) {
        switch (type) {
            case Directory: {
                return DIRECTORY;
            }
            case Missing: {
                return MISSING_FILE;
            }
            case RegularFile: {
                return new IgnoredPathFileSystemLocationFingerprint(FileType.RegularFile, contentHash);
            }
        }
        throw new IllegalStateException();
    }

    private IgnoredPathFileSystemLocationFingerprint(FileType type, HashCode normalizedContentHash) {
        this.type = type;
        this.normalizedContentHash = normalizedContentHash;
    }

    @Override
    public String getNormalizedPath() {
        return "";
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public int compareTo(FileSystemLocationFingerprint o) {
        if (!(o instanceof IgnoredPathFileSystemLocationFingerprint)) {
            return -1;
        }
        return this.normalizedContentHash.compareTo(o.getNormalizedContentHash());
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putHash(this.normalizedContentHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredPathFileSystemLocationFingerprint that = (IgnoredPathFileSystemLocationFingerprint)o;
        return this.normalizedContentHash.equals(that.normalizedContentHash);
    }

    public int hashCode() {
        return this.normalizedContentHash.hashCode();
    }

    public String toString() {
        return String.format("IGNORED / %s", this.getType() == FileType.Directory ? "DIR" : (this.getType() == FileType.Missing ? "MISSING" : this.normalizedContentHash));
    }
}

