/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.impldep.com.google.common.io.Files;

class ChecksumHasher
implements FileHasher {
    private final HashFunction hashFunction;

    public ChecksumHasher(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    @Override
    public HashCode hash(File file) {
        try {
            return this.hashFunction.hashBytes(Files.toByteArray((File)file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HashCode hash(File file, long length, long lastModified) {
        return this.hash(file);
    }
}

