/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;

public class LinePrefixingStyledTextOutput
extends AbstractLineChoppingStyledTextOutput {
    private final StyledTextOutput output;
    private final CharSequence prefix;
    private boolean prefixFirstLine;
    private boolean prefixed;

    public LinePrefixingStyledTextOutput(StyledTextOutput output, CharSequence prefix) {
        this(output, prefix, true);
    }

    public LinePrefixingStyledTextOutput(StyledTextOutput output, CharSequence prefix, boolean prefixFirstLine) {
        this.output = output;
        this.prefix = prefix;
        this.prefixFirstLine = prefixFirstLine;
    }

    @Override
    protected void doLineText(CharSequence text) {
        if (!this.prefixed && this.prefixFirstLine) {
            this.output.text(this.prefix);
            this.prefixed = true;
        }
        this.output.text(text);
    }

    @Override
    protected void doEndLine(CharSequence endOfLine) {
        this.output.text(endOfLine);
    }

    @Override
    protected void doStartLine() {
        this.output.text(this.prefix);
    }

    @Override
    protected void doStyleChange(StyledTextOutput.Style style) {
        this.output.style(style);
    }
}

