/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;

public class LoggingBuildOperationProgressBroadcaster
implements Stoppable,
OutputEventListener {
    private final OutputEventListenerManager outputEventListenerManager;
    private final BuildOperationListener buildOperationListener;
    @VisibleForTesting
    OperationIdentifier rootBuildOperation;

    public LoggingBuildOperationProgressBroadcaster(OutputEventListenerManager outputEventListenerManager, BuildOperationListener buildOperationListener) {
        this.outputEventListenerManager = outputEventListenerManager;
        this.buildOperationListener = buildOperationListener;
        outputEventListenerManager.setListener(this);
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent renderableOutputEvent = (RenderableOutputEvent)event;
            OperationIdentifier operationIdentifier = renderableOutputEvent.getBuildOperationId();
            if (operationIdentifier == null) {
                if (this.rootBuildOperation == null) {
                    return;
                }
                operationIdentifier = this.rootBuildOperation;
            }
            if (renderableOutputEvent instanceof StyledTextOutputEvent || renderableOutputEvent instanceof LogEvent) {
                this.emit(renderableOutputEvent, operationIdentifier);
            }
        } else if (event instanceof ProgressStartEvent) {
            ProgressStartEvent progressStartEvent = (ProgressStartEvent)event;
            if (progressStartEvent.getLoggingHeader() == null) {
                return;
            }
            OperationIdentifier operationIdentifier = progressStartEvent.getBuildOperationId();
            if (operationIdentifier == null && this.rootBuildOperation != null) {
                operationIdentifier = this.rootBuildOperation;
            }
            this.emit(progressStartEvent, operationIdentifier);
        }
    }

    private void emit(CategorisedOutputEvent event, OperationIdentifier buildOperationId) {
        this.buildOperationListener.progress(buildOperationId, new OperationProgressEvent(event.getTimestamp(), event));
    }

    @Override
    public void stop() {
        this.outputEventListenerManager.removeListener(this);
    }

    public void rootBuildOperationStarted() {
        this.rootBuildOperation = CurrentBuildOperationRef.instance().getId();
    }
}

