/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.AbstractFileSystemNode;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractIncompleteSnapshotWithChildren
extends AbstractFileSystemNode {
    protected final List<? extends FileSystemNode> children;

    public AbstractIncompleteSnapshotWithChildren(String pathToParent, List<? extends FileSystemNode> children) {
        super(pathToParent);
        this.children = children;
    }

    @Override
    public Optional<FileSystemNode> invalidate(final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity) {
        return SnapshotUtil.handleChildren(this.children, relativePath, caseSensitivity, new SnapshotUtil.ChildHandler<Optional<FileSystemNode>>(){

            @Override
            public Optional<FileSystemNode> handleNewChild(int insertBefore) {
                return Optional.of(AbstractIncompleteSnapshotWithChildren.this.withIncompleteChildren());
            }

            @Override
            public Optional<FileSystemNode> handleChildOfExisting(int childIndex) {
                FileSystemNode child = AbstractIncompleteSnapshotWithChildren.this.children.get(childIndex);
                return SnapshotUtil.invalidateSingleChild(child, relativePath, caseSensitivity).map(invalidatedChild -> AbstractIncompleteSnapshotWithChildren.this.withReplacedChild(childIndex, child, invalidatedChild)).map(Optional::of).orElseGet(() -> {
                    if (AbstractIncompleteSnapshotWithChildren.this.children.size() == 1) {
                        return AbstractIncompleteSnapshotWithChildren.this.withAllChildrenRemoved();
                    }
                    ArrayList<? extends FileSystemNode> merged = new ArrayList<FileSystemNode>(AbstractIncompleteSnapshotWithChildren.this.children);
                    merged.remove(childIndex);
                    return Optional.of(AbstractIncompleteSnapshotWithChildren.this.withIncompleteChildren(AbstractIncompleteSnapshotWithChildren.this.getPathToParent(), merged));
                });
            }
        });
    }

    @Override
    public FileSystemNode store(final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity, final MetadataSnapshot snapshot) {
        return SnapshotUtil.handleChildren(this.children, relativePath, caseSensitivity, new SnapshotUtil.ChildHandler<FileSystemNode>(){

            @Override
            public FileSystemNode handleNewChild(int insertBefore) {
                ArrayList<? extends FileSystemNode> newChildren = new ArrayList<FileSystemNode>(AbstractIncompleteSnapshotWithChildren.this.children);
                newChildren.add(insertBefore, snapshot.asFileSystemNode(relativePath.getAsString()));
                return AbstractIncompleteSnapshotWithChildren.this.withIncompleteChildren(AbstractIncompleteSnapshotWithChildren.this.getPathToParent(), newChildren);
            }

            @Override
            public FileSystemNode handleChildOfExisting(int childIndex) {
                FileSystemNode child = AbstractIncompleteSnapshotWithChildren.this.children.get(childIndex);
                return AbstractIncompleteSnapshotWithChildren.this.withReplacedChild(childIndex, child, SnapshotUtil.storeSingleChild(child, relativePath, caseSensitivity, snapshot));
            }
        });
    }

    @Override
    public FileSystemNode withPathToParent(String newPathToParent) {
        return this.getPathToParent().equals(newPathToParent) ? this : this.withIncompleteChildren(newPathToParent, this.children);
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return SnapshotUtil.getMetadataFromChildren(this.children, relativePath, caseSensitivity, Optional::empty);
    }

    protected abstract FileSystemNode withIncompleteChildren();

    protected abstract FileSystemNode withIncompleteChildren(String var1, List<? extends FileSystemNode> var2);

    protected abstract Optional<FileSystemNode> withAllChildrenRemoved();

    private FileSystemNode withReplacedChild(int childIndex, FileSystemNode childToReplace, FileSystemNode newChild) {
        if (newChild == childToReplace) {
            return this;
        }
        if (this.children.size() == 1) {
            return this.withIncompleteChildren(this.getPathToParent(), (List<? extends FileSystemNode>)ImmutableList.of((Object)newChild));
        }
        ArrayList<? extends FileSystemNode> merged = new ArrayList<FileSystemNode>(this.children);
        merged.set(childIndex, newChild);
        return this.withIncompleteChildren(this.getPathToParent(), merged);
    }

    @Override
    public void accept(FileSystemNode.NodeVisitor visitor) {
        visitor.visitNode(this);
        for (FileSystemNode fileSystemNode : this.children) {
            fileSystemNode.accept(visitor);
        }
    }
}

