/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileMetadata;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySnapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectorySnapshotter.class);
    private final FileHasher hasher;
    private final Interner<String> stringInterner;
    private final DefaultExcludes defaultExcludes;

    public DirectorySnapshotter(FileHasher hasher, Interner<String> stringInterner, String ... defaultExcludes) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.defaultExcludes = new DefaultExcludes(defaultExcludes);
    }

    public CompleteFileSystemLocationSnapshot snapshot(String absolutePath, @Nullable SnapshottingFilter.DirectoryWalkerPredicate predicate, AtomicBoolean hasBeenFiltered) {
        try {
            Path rootPath = Paths.get(absolutePath, new String[0]);
            PathVisitor visitor = new PathVisitor(predicate, hasBeenFiltered, this.hasher, this.stringInterner, this.defaultExcludes);
            Files.walkFileTree(rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
            return visitor.getResult();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", absolutePath), e);
        }
    }

    private static class PathVisitor
    implements FileVisitor<Path> {
        private final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.sortingRequired();
        private final SnapshottingFilter.DirectoryWalkerPredicate predicate;
        private final AtomicBoolean hasBeenFiltered;
        private final FileHasher hasher;
        private final Interner<String> stringInterner;
        private final DefaultExcludes defaultExcludes;

        public PathVisitor(@Nullable SnapshottingFilter.DirectoryWalkerPredicate predicate, AtomicBoolean hasBeenFiltered, FileHasher hasher, Interner<String> stringInterner, DefaultExcludes defaultExcludes) {
            this.predicate = predicate;
            this.hasBeenFiltered = hasBeenFiltered;
            this.hasher = hasher;
            this.stringInterner = stringInterner;
            this.defaultExcludes = defaultExcludes;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            String fileName = this.getFilename(dir);
            String internedName = this.intern(fileName);
            if (this.builder.isRoot() || this.shouldVisit(dir, internedName, true, attrs, this.builder.getRelativePath())) {
                this.builder.preVisitDirectory(this.intern(dir.toString()), internedName);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        private String getFilename(Path dir) {
            return Optional.ofNullable(dir.getFileName()).map(Object::toString).orElse("");
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            String internedName = this.intern(file.getFileName().toString());
            if (this.shouldVisit(file, internedName, false, attrs, this.builder.getRelativePath())) {
                this.builder.visitFile(this.snapshotFile(file, internedName, attrs));
            }
            return FileVisitResult.CONTINUE;
        }

        private CompleteFileSystemLocationSnapshot snapshotFile(Path absoluteFilePath, String internedName, BasicFileAttributes attrs) {
            String internedAbsoluteFilePath = this.intern(absoluteFilePath.toString());
            if (attrs.isRegularFile()) {
                try {
                    HashCode hash = this.hasher.hash(absoluteFilePath.toFile(), attrs.size(), attrs.lastModifiedTime().toMillis());
                    FileMetadata metadata = FileMetadata.from(attrs);
                    return new RegularFileSnapshot(internedAbsoluteFilePath, internedName, hash, metadata);
                }
                catch (UncheckedIOException e) {
                    LOGGER.info("Could not read file path '{}'.", (Object)absoluteFilePath, (Object)e);
                }
            }
            return new MissingFileSnapshot(internedAbsoluteFilePath, internedName);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            boolean isDirectory;
            String internedName;
            if (this.isNotFileSystemLoopException(exc) && this.shouldVisit(file, internedName = this.intern(file.getFileName().toString()), isDirectory = Files.isDirectory(file, new LinkOption[0]), null, this.builder.getRelativePath())) {
                LOGGER.info("Could not read file path '{}'.", (Object)file);
                String internedAbsolutePath = this.intern(file.toString());
                this.builder.visitFile(new MissingFileSnapshot(internedAbsolutePath, internedName));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) {
            if (this.isNotFileSystemLoopException(exc)) {
                throw new UncheckedIOException(String.format("Could not read directory path '%s'.", dir), exc);
            }
            this.builder.postVisitDirectory();
            return FileVisitResult.CONTINUE;
        }

        private boolean isNotFileSystemLoopException(@Nullable IOException e) {
            return e != null && !(e instanceof FileSystemLoopException);
        }

        private String intern(String string) {
            return (String)this.stringInterner.intern((Object)string);
        }

        private boolean shouldVisit(Path path, String internedName, boolean isDirectory, @Nullable BasicFileAttributes attrs, Iterable<String> relativePath) {
            if (isDirectory ? this.defaultExcludes.excludeDir(internedName) : this.defaultExcludes.excludeFile(internedName)) {
                return false;
            }
            if (this.predicate == null) {
                return true;
            }
            boolean allowed = this.predicate.test(path, internedName, isDirectory, relativePath);
            if (!allowed) {
                this.hasBeenFiltered.set(true);
            }
            return allowed;
        }

        public CompleteFileSystemLocationSnapshot getResult() {
            return this.builder.getResult();
        }
    }

    @VisibleForTesting
    static class DefaultExcludes {
        private final ImmutableSet<String> excludeFileNames;
        private final ImmutableSet<String> excludedDirNames;
        private final Predicate<String> excludedFileNameSpec;

        public DefaultExcludes(String[] defaultExcludes) {
            ArrayList excludeFiles = Lists.newArrayList();
            ArrayList excludeDirs = Lists.newArrayList();
            ArrayList excludeFileSpecs = Lists.newArrayList();
            for (String defaultExclude : defaultExcludes) {
                if (defaultExclude.startsWith("**/")) {
                    defaultExclude = defaultExclude.substring(3);
                }
                int length = defaultExclude.length();
                if (defaultExclude.endsWith("/**")) {
                    excludeDirs.add(defaultExclude.substring(0, length - 3));
                    continue;
                }
                int firstStar = defaultExclude.indexOf(42);
                if (firstStar == -1) {
                    excludeFiles.add(defaultExclude);
                    continue;
                }
                StartMatcher start = firstStar == 0 ? it -> true : new StartMatcher(defaultExclude.substring(0, firstStar));
                EndMatcher end = firstStar == length - 1 ? it -> true : new EndMatcher(defaultExclude.substring(firstStar + 1, length));
                excludeFileSpecs.add(start.and(end));
            }
            this.excludeFileNames = ImmutableSet.copyOf((Collection)excludeFiles);
            this.excludedFileNameSpec = excludeFileSpecs.stream().reduce(it -> false, Predicate::or);
            this.excludedDirNames = ImmutableSet.copyOf((Collection)excludeDirs);
        }

        public boolean excludeDir(String name) {
            return this.excludedDirNames.contains((Object)name);
        }

        public boolean excludeFile(String name) {
            return this.excludeFileNames.contains((Object)name) || this.excludedFileNameSpec.test(name);
        }

        private static class StartMatcher
        implements Predicate<String> {
            private final String start;

            public StartMatcher(String start) {
                this.start = start;
            }

            @Override
            public boolean test(String element) {
                return element.startsWith(this.start);
            }
        }

        private static class EndMatcher
        implements Predicate<String> {
            private final String end;

            public EndMatcher(String end) {
                this.end = end;
            }

            @Override
            public boolean test(String element) {
                return element.endsWith(this.end);
            }
        }
    }
}

