/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.toolchain.DefaultScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.NotFoundScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.ScalaToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DownloadingScalaToolChain
implements ScalaToolChainInternal {
    private final File gradleUserHomeDir;
    private final File daemonWorkingDir;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final JavaVersion javaVersion;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public DownloadingScalaToolChain(File gradleUserHomeDir, File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.forkOptionsFactory = forkOptionsFactory;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.javaVersion = JavaVersion.current();
    }

    @Override
    public String getName() {
        return "Scala Toolchain";
    }

    @Override
    public String getDisplayName() {
        return "Scala Toolchain (JDK " + this.javaVersion.getMajorVersion() + " (" + (Object)((Object)this.javaVersion) + "))";
    }

    @Override
    public ToolProvider select(ScalaPlatform targetPlatform) {
        try {
            Dependency scalaCompiler = this.dependencyHandler.create("org.scala-lang:scala-compiler:" + targetPlatform.getScalaVersion());
            Dependency compilerBridge = this.dependencyHandler.create("org.scala-sbt:compiler-bridge_" + targetPlatform.getScalaCompatibilityVersion() + ":" + "1.3.0" + ":sources@jar");
            Dependency compilerInterface = this.dependencyHandler.create("org.scala-sbt:compiler-interface:1.3.0");
            Configuration scalaClasspath = this.resolveDependency(scalaCompiler, compilerBridge, compilerInterface);
            Set<File> resolvedScalaClasspath = scalaClasspath.resolve();
            Configuration zincClasspath = this.resolveDependency(this.dependencyHandler.create("org.scala-sbt:zinc_2.12:1.3.0"));
            Set<File> resolvedZincClasspath = zincClasspath.resolve();
            return new DefaultScalaToolProvider(this.daemonWorkingDir, this.workerDaemonFactory, this.forkOptionsFactory, resolvedScalaClasspath, resolvedZincClasspath, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory);
        }
        catch (ResolveException resolveException) {
            return new NotFoundScalaToolProvider(resolveException);
        }
    }

    private Configuration resolveDependency(Dependency ... dependencies) {
        return this.configurationContainer.detachedConfiguration(dependencies);
    }
}

