/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.Transformer;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class InProcessBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionRunner buildActionRunner;

    public InProcessBuildActionExecuter(BuildActionRunner buildActionRunner) {
        this.buildActionRunner = buildActionRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(final BuildAction action, final BuildRequestContext buildRequestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        BuildStateRegistry buildRegistry = contextServices.get(BuildStateRegistry.class);
        final PayloadSerializer payloadSerializer = contextServices.get(PayloadSerializer.class);
        BuildOperationNotificationValve buildOperationNotificationValve = contextServices.get(BuildOperationNotificationValve.class);
        buildOperationNotificationValve.start();
        try {
            RootBuildState rootBuild = buildRegistry.createRootBuild(BuildDefinition.fromStartParameter(action.getStartParameter(), null));
            BuildActionResult buildActionResult = rootBuild.run(new Transformer<BuildActionResult, BuildController>(){

                @Override
                public BuildActionResult transform(BuildController buildController) {
                    BuildActionRunner.Result result = InProcessBuildActionExecuter.this.buildActionRunner.run(action, buildController);
                    if (result.getBuildFailure() == null) {
                        return BuildActionResult.of(payloadSerializer.serialize(result.getClientResult()));
                    }
                    if (buildRequestContext.getCancellationToken().isCancellationRequested()) {
                        return BuildActionResult.cancelled(payloadSerializer.serialize(result.getBuildFailure()));
                    }
                    return BuildActionResult.failed(payloadSerializer.serialize(result.getClientFailure()));
                }
            });
            return buildActionResult;
        }
        finally {
            buildOperationNotificationValve.stop();
        }
    }
}

