/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.platform.base.internal.toolchain.ComponentFound;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;

public abstract class AbstractMetadataProvider<T extends CompilerMetadata>
implements CompilerMetaDataProvider<T> {
    private final ExecActionFactory execActionFactory;

    public AbstractMetadataProvider(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    @Override
    public SearchResult<T> getCompilerMetaData(List<File> path, Action<? super CompilerMetaDataProvider.CompilerExecSpec> configureAction) {
        DefaultCompilerExecSpec execSpec = new DefaultCompilerExecSpec();
        configureAction.execute(execSpec);
        ImmutableList allArgs = ImmutableList.builder().addAll(execSpec.args).addAll(this.compilerArgs()).build();
        Pair<String, String> transform = this.runCompiler(execSpec.executable, (List<String>)allArgs, execSpec.environments);
        if (transform == null) {
            return new ComponentNotFound(String.format("Could not determine %s metadata: failed to execute %s %s.", this.getCompilerType().getDescription(), execSpec.executable.getName(), Joiner.on((char)' ').join((Iterable)allArgs)));
        }
        String output = transform.getLeft();
        String error = transform.getRight();
        try {
            return new ComponentFound<T>(this.parseCompilerOutput(output, error, execSpec.executable, path));
        }
        catch (BrokenResultException e) {
            return new ComponentNotFound(e.getMessage());
        }
    }

    protected ExecActionFactory getExecActionFactory() {
        return this.execActionFactory;
    }

    protected abstract T parseCompilerOutput(String var1, String var2, File var3, List<File> var4) throws BrokenResultException;

    private Pair<String, String> runCompiler(File gccBinary, List<String> args, Map<String, ?> environmentVariables) {
        String errorBufferAsString;
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.executable(gccBinary.getAbsolutePath());
        exec.setWorkingDir(gccBinary.getParentFile());
        exec.args(args);
        exec.environment(environmentVariables);
        StreamByteBuffer buffer = new StreamByteBuffer();
        StreamByteBuffer errorBuffer = new StreamByteBuffer();
        exec.setStandardOutput(buffer.getOutputStream());
        exec.setErrorOutput(errorBuffer.getOutputStream());
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return Pair.of(buffer.readAsString(), errorBuffer.readAsString());
        }
        if (exitValue == 69 && (errorBufferAsString = errorBuffer.readAsString()).contains("Agreeing to the Xcode")) {
            throw new IllegalStateException("You will be unable to use Xcode's tool chain until you accept the Xcode license.\n" + errorBufferAsString);
        }
        return null;
    }

    protected abstract List<String> compilerArgs();

    public static class DefaultCompilerExecSpec
    implements CompilerMetaDataProvider.CompilerExecSpec {
        public final Map<String, String> environments = new HashMap<String, String>();
        public final List<String> args = new ArrayList<String>();
        public File executable;

        @Override
        public CompilerMetaDataProvider.CompilerExecSpec environment(String key, String value) {
            this.environments.put(key, value);
            return this;
        }

        @Override
        public CompilerMetaDataProvider.CompilerExecSpec executable(File executable) {
            this.executable = executable;
            return this;
        }

        @Override
        public CompilerMetaDataProvider.CompilerExecSpec args(Iterable<String> args) {
            this.args.addAll((Collection<String>)ImmutableList.copyOf(args));
            return this;
        }
    }

    public static class BrokenResultException
    extends RuntimeException {
        public BrokenResultException(String message) {
            super(message);
        }
    }
}

