/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.IdeDependencySet;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;
import org.gradle.plugins.ide.internal.resolver.UnresolvedIdeDependencyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseDependenciesCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseDependenciesCreator.class);
    private final EclipseClasspath classpath;
    private final ProjectDependencyBuilder projectDependencyBuilder;
    private final ProjectComponentIdentifier currentProjectId;

    public EclipseDependenciesCreator(EclipseClasspath classpath, IdeArtifactRegistry ideArtifactRegistry, ProjectStateRegistry projectRegistry) {
        this.classpath = classpath;
        this.projectDependencyBuilder = new ProjectDependencyBuilder(ideArtifactRegistry);
        this.currentProjectId = projectRegistry.stateFor(classpath.getProject()).getComponentIdentifier();
    }

    public List<AbstractClasspathEntry> createDependencyEntries() {
        EclipseDependenciesVisitor visitor = new EclipseDependenciesVisitor(this.classpath.getProject());
        new IdeDependencySet(this.classpath.getProject().getDependencies(), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations()).visit(visitor);
        return visitor.getDependencies();
    }

    private class EclipseDependenciesVisitor
    implements IdeDependencyVisitor {
        private final List<AbstractClasspathEntry> projects = Lists.newArrayList();
        private final List<AbstractClasspathEntry> modules = Lists.newArrayList();
        private final List<AbstractClasspathEntry> files = Lists.newArrayList();
        private final Multimap<String, String> pathToSourceSets = this.collectLibraryToSourceSetMapping();
        private final UnresolvedIdeDependencyHandler unresolvedIdeDependencyHandler = new UnresolvedIdeDependencyHandler();
        private final Project project;

        public EclipseDependenciesVisitor(Project project) {
            this.project = project;
        }

        @Override
        public boolean isOffline() {
            return EclipseDependenciesCreator.this.classpath.isProjectDependenciesOnly();
        }

        @Override
        public boolean downloadSources() {
            return EclipseDependenciesCreator.this.classpath.isDownloadSources();
        }

        @Override
        public boolean downloadJavaDoc() {
            return EclipseDependenciesCreator.this.classpath.isDownloadJavadoc();
        }

        @Override
        public void visitProjectDependency(ResolvedArtifactResult artifact) {
            ProjectComponentIdentifier componentIdentifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
            if (componentIdentifier.equals(EclipseDependenciesCreator.this.currentProjectId)) {
                return;
            }
            LibraryElements libraryElements = artifact.getVariant().getAttributes().getAttribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
            if (libraryElements == null || !libraryElements.getName().equals("jar")) {
                return;
            }
            ComponentArtifactMetadata artifactId = (ComponentArtifactMetadata)((Object)artifact.getId());
            this.projects.add(EclipseDependenciesCreator.this.projectDependencyBuilder.build(componentIdentifier, EclipseDependenciesCreator.this.classpath.getFileReferenceFactory().fromFile(artifact.getFile()), artifactId.getBuildDependencies()));
        }

        @Override
        public void visitModuleDependency(ResolvedArtifactResult artifact, Set<ResolvedArtifactResult> sources, Set<ResolvedArtifactResult> javaDoc, boolean testDependency) {
            File sourceFile = sources.isEmpty() ? null : sources.iterator().next().getFile();
            File javaDocFile = javaDoc.isEmpty() ? null : javaDoc.iterator().next().getFile();
            ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
            ModuleVersionIdentifier moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId(componentIdentifier.getModuleIdentifier(), componentIdentifier.getVersion());
            this.modules.add(this.createLibraryEntry(artifact.getFile(), sourceFile, javaDocFile, EclipseDependenciesCreator.this.classpath, moduleVersionIdentifier, this.pathToSourceSets, testDependency));
        }

        @Override
        public void visitFileDependency(ResolvedArtifactResult artifact, boolean testDependency) {
            this.files.add(this.createLibraryEntry(artifact.getFile(), null, null, EclipseDependenciesCreator.this.classpath, null, this.pathToSourceSets, testDependency));
        }

        @Override
        public void visitUnresolvedDependency(UnresolvedDependencyResult unresolvedDependency) {
            File unresolvedFile = this.unresolvedIdeDependencyHandler.asFile(unresolvedDependency, this.project.getProjectDir());
            this.files.add(this.createLibraryEntry(unresolvedFile, null, null, EclipseDependenciesCreator.this.classpath, null, this.pathToSourceSets, false));
            this.unresolvedIdeDependencyHandler.log(unresolvedDependency);
        }

        public List<AbstractClasspathEntry> getDependencies() {
            ArrayList dependencies = Lists.newArrayListWithCapacity((int)(this.projects.size() + this.modules.size() + this.files.size()));
            dependencies.addAll(this.projects);
            dependencies.addAll(this.modules);
            dependencies.addAll(this.files);
            return dependencies;
        }

        private Multimap<String, String> collectLibraryToSourceSetMapping() {
            LinkedHashMultimap pathToSourceSetNames = LinkedHashMultimap.create();
            Iterable<SourceSet> sourceSets = EclipseDependenciesCreator.this.classpath.getSourceSets();
            if (sourceSets == null) {
                return pathToSourceSetNames;
            }
            for (SourceSet sourceSet : sourceSets) {
                for (File f : this.collectClasspathFiles(sourceSet)) {
                    pathToSourceSetNames.put((Object)f.getAbsolutePath(), (Object)sourceSet.getName().replace(",", ""));
                }
            }
            return pathToSourceSetNames;
        }

        private Collection<File> collectClasspathFiles(SourceSet sourceSet) {
            ImmutableList.Builder result = ImmutableList.builder();
            try {
                result.addAll((Iterable)sourceSet.getRuntimeClasspath());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to collect source sets for Eclipse dependencies", (Throwable)e);
            }
            return result.build();
        }

        private AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, EclipseClasspath classpath, ModuleVersionIdentifier id, Multimap<String, String> pathToSourceSets, boolean testDependency) {
            FileReferenceFactory referenceFactory = classpath.getFileReferenceFactory();
            FileReference binaryRef = referenceFactory.fromFile(binary);
            FileReference sourceRef = referenceFactory.fromFile(source);
            FileReference javadocRef = referenceFactory.fromFile(javadoc);
            AbstractLibrary out = binaryRef.isRelativeToPathVariable() ? new Variable(binaryRef) : new Library(binaryRef);
            out.setJavadocPath(javadocRef);
            out.setSourcePath(sourceRef);
            out.setExported(false);
            out.setModuleVersion(id);
            Collection sourceSets = pathToSourceSets.get((Object)binary.getAbsolutePath());
            if (sourceSets != null) {
                out.getEntryAttributes().put("gradle_used_by_scope", Joiner.on((char)',').join((Iterable)sourceSets));
            }
            if (testDependency) {
                out.getEntryAttributes().put("test", "true");
            }
            return out;
        }
    }
}

