/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.XmlParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.XmlProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;
import org.gradle.util.ConfigureUtil;

public abstract class XmlPersistableConfigurationObject
extends AbstractPersistableConfigurationObject {
    private final XmlTransformer xmlTransformer;
    private Node xml;

    protected XmlPersistableConfigurationObject(XmlTransformer xmlTransformer) {
        this.xmlTransformer = xmlTransformer;
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.xml = new XmlParser().parse(inputStream);
        this.load(this.xml);
    }

    @Override
    public void store(OutputStream outputStream) {
        this.store(this.xml);
        this.xmlTransformer.transform(this.xml, outputStream);
    }

    public Node getXml() {
        return this.xml;
    }

    protected void load(Node xml) {
    }

    protected void store(Node xml) {
    }

    public void transformAction(Closure action) {
        this.transformAction(ConfigureUtil.configureUsing(action));
    }

    public void transformAction(Action<? super XmlProvider> action) {
        this.xmlTransformer.addAction(action);
    }

    protected static List<Node> getChildren(@Nullable Node root, String name) {
        return root == null ? Collections.emptyList() : (List)Cast.uncheckedCast(root.get(name));
    }

    @Nullable
    public static Node findFirstChildNamed(@Nullable Node root, String name) {
        return root == null ? null : (Node)Iterables.getFirst(XmlPersistableConfigurationObject.getChildren(root, name), null);
    }

    @Nullable
    public static Node findFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        return root == null ? null : XmlPersistableConfigurationObject.findFirstWithAttributeValue(XmlPersistableConfigurationObject.getChildren(root, childName), attribute, value);
    }

    @Nullable
    protected static Node findFirstWithAttributeValue(@Nullable List<Node> nodes, final String attribute, final String value) {
        return nodes == null ? null : (Node)Iterables.getFirst((Iterable)Iterables.filter(nodes, (Predicate)new Predicate<Node>(){

            public boolean apply(Node node) {
                return value.equals(node.attribute((Object)attribute));
            }
        }), null);
    }

    public static Node findOrCreateFirstChildNamed(Node root, String name) {
        Node child = XmlPersistableConfigurationObject.findFirstChildNamed(root, name);
        if (child == null) {
            child = root.appendNode((Object)name);
        }
        return child;
    }

    public static Node findOrCreateFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        Node child = XmlPersistableConfigurationObject.findFirstChildWithAttributeValue(root, childName, attribute, value);
        if (child == null) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put(attribute, value);
            child = root.appendNode((Object)childName, (Map)attributes);
        }
        return child;
    }
}

