/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.javascript.base.JavaScriptBasePlugin;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoShellExec;
import org.gradle.util.DeprecationLogger;

public class RhinoPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        DeprecationLogger.nagUserOfDeprecatedPlugin("org.gradle.rhino");
        project.getPluginManager().apply(JavaScriptBasePlugin.class);
        JavaScriptExtension jsExtension = project.getExtensions().findByType(JavaScriptExtension.class);
        final RhinoExtension rhinoExtension = ((ExtensionAware)((Object)jsExtension)).getExtensions().create("rhino", RhinoExtension.class, new Object[0]);
        final Configuration configuration = this.addClasspathConfiguration(project.getConfigurations());
        this.configureDefaultRhinoDependency(configuration, project.getDependencies(), rhinoExtension);
        ConventionMapping conventionMapping = ((IConventionAware)((Object)rhinoExtension)).getConventionMapping();
        conventionMapping.map("classpath", new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return configuration;
            }
        });
        conventionMapping.map("version", new Callable<String>(){

            @Override
            public String call() {
                return "1.7R3";
            }
        });
        project.getTasks().withType(RhinoShellExec.class, new Action<RhinoShellExec>(){

            @Override
            public void execute(RhinoShellExec task) {
                task.getConventionMapping().map("classpath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return rhinoExtension.getClasspath();
                    }
                });
                task.getConventionMapping().map("main", new Callable<String>(){

                    @Override
                    public String call() {
                        return "org.gradle.internal.impldep.org.mozilla.javascript.tools.shell.Main";
                    }
                });
                task.setClasspath(rhinoExtension.getClasspath());
            }
        });
    }

    private Configuration addClasspathConfiguration(ConfigurationContainer configurations) {
        Configuration configuration = (Configuration)configurations.create("rhinoPluginRhinoClasspath");
        configuration.setVisible(false);
        configuration.setDescription("The default Rhino classpath");
        return configuration;
    }

    public void configureDefaultRhinoDependency(Configuration configuration, final DependencyHandler dependencyHandler, final RhinoExtension extension) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                Dependency dependency = dependencyHandler.create("org.mozilla:rhino:" + extension.getVersion());
                dependencies.add(dependency);
            }
        });
    }
}

