/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.annotation.Nullable;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.FixedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerPublicServicesBuilder;
import org.gradle.workers.internal.WorkerRequirement;

public class NoIsolationWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ServiceRegistry parent;
    private WorkerExecutor workerExecutor;

    public NoIsolationWorkerFactory(BuildOperationExecutor buildOperationExecutor, ServiceRegistry parent) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.parent = parent;
    }

    public void setWorkerExecutor(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @Override
    public BuildOperationAwareWorker getWorker(WorkerRequirement workerRequirement) {
        final WorkerExecutor workerExecutor = this.workerExecutor;
        final ClassLoader contextClassLoader = ((FixedClassLoaderWorkerRequirement)workerRequirement).getContextClassLoader();
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, workSpec -> {
                    DefaultWorkResult result;
                    try {
                        DefaultServiceRegistry serviceRegistry = new WorkerPublicServicesBuilder(NoIsolationWorkerFactory.this.parent).withInternalServicesVisible(workSpec.isInternalServicesRequired()).build();
                        serviceRegistry.add(WorkerExecutor.class, workerExecutor);
                        final DefaultWorkerServer workerServer = new DefaultWorkerServer(serviceRegistry, NoIsolationWorkerFactory.this.parent.get(InstantiatorFactory.class));
                        result = ClassLoaderUtils.executeInClassloader(contextClassLoader, new Factory<DefaultWorkResult>(){

                            @Override
                            @Nullable
                            public DefaultWorkResult create() {
                                return workerServer.execute(workSpec);
                            }
                        });
                    }
                    finally {
                        workerExecutor.await();
                    }
                    return result;
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.NONE;
    }
}

