/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructureSerializer;
import org.gradle.workers.internal.TransportableActionExecutionSpec;

public class TransportableActionExecutionSpecSerializer
implements Serializer<TransportableActionExecutionSpec> {
    private static final byte FLAT = 0;
    private static final byte HIERARCHICAL = 1;
    private final Serializer<HierarchicalClassLoaderStructure> hierarchicalClassLoaderStructureSerializer = new HierarchicalClassLoaderStructureSerializer();

    @Override
    public void write(Encoder encoder, TransportableActionExecutionSpec spec) throws Exception {
        encoder.writeString(spec.getDisplayName());
        encoder.writeString(spec.getImplementationClassName());
        encoder.writeBoolean(spec.isInternalServicesRequired());
        encoder.writeString(spec.getBaseDir().getAbsolutePath());
        encoder.writeInt(spec.getSerializedParameters().length);
        encoder.writeBytes(spec.getSerializedParameters());
        if (spec.getClassLoaderStructure() instanceof HierarchicalClassLoaderStructure) {
            encoder.writeByte((byte)1);
            this.hierarchicalClassLoaderStructureSerializer.write(encoder, (HierarchicalClassLoaderStructure)spec.getClassLoaderStructure());
        } else if (spec.getClassLoaderStructure() instanceof FlatClassLoaderStructure) {
            encoder.writeByte((byte)0);
        } else {
            throw new IllegalArgumentException("Unknown classloader structure type: " + spec.getClassLoaderStructure().getClass().getSimpleName());
        }
    }

    @Override
    public TransportableActionExecutionSpec read(Decoder decoder) throws Exception {
        ClassLoaderStructure classLoaderStructure;
        String displayName = decoder.readString();
        String implementationClassName = decoder.readString();
        boolean usesInternalServices = decoder.readBoolean();
        String baseDirPath = decoder.readString();
        int parametersSize = decoder.readInt();
        byte[] serializedParameters = new byte[parametersSize];
        decoder.readBytes(serializedParameters);
        byte classLoaderStructureTag = decoder.readByte();
        switch (classLoaderStructureTag) {
            case 0: {
                classLoaderStructure = new FlatClassLoaderStructure(null);
                break;
            }
            case 1: {
                classLoaderStructure = this.hierarchicalClassLoaderStructureSerializer.read(decoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected payload type.");
            }
        }
        return new TransportableActionExecutionSpec(displayName, implementationClassName, serializedParameters, classLoaderStructure, new File(baseDirPath), usesInternalServices);
    }
}

