/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonProcess;

class WorkerDaemonClient
implements BuildOperationAwareWorker,
Stoppable {
    public static final String DISABLE_EXPIRATION_PROPERTY_KEY = "org.gradle.workers.internal.disable-daemons-expiration";
    private final DaemonForkOptions forkOptions;
    private final WorkerDaemonProcess workerDaemonProcess;
    private final WorkerProcess workerProcess;
    private final LogLevel logLevel;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private int uses;
    private boolean failed;
    private boolean cannotBeExpired = Boolean.getBoolean("org.gradle.workers.internal.disable-daemons-expiration");

    public WorkerDaemonClient(DaemonForkOptions forkOptions, WorkerDaemonProcess workerDaemonProcess, WorkerProcess workerProcess, LogLevel logLevel, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.forkOptions = forkOptions;
        this.workerDaemonProcess = workerDaemonProcess;
        this.workerProcess = workerProcess;
        this.logLevel = logLevel;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
        return this.execute(spec);
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        ++this.uses;
        return this.workerDaemonProcess.execute(this.actionExecutionSpecFactory.newTransportableSpec(spec));
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    JvmMemoryStatus getJvmMemoryStatus() {
        return this.workerProcess.getJvmMemoryStatus();
    }

    @Override
    public void stop() {
        this.workerDaemonProcess.stop();
    }

    DaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public int getUses() {
        return this.uses;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.forkOptions.getKeepAliveMode();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public boolean isProcess(WorkerProcess workerProcess) {
        return this.workerProcess.equals(workerProcess);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isNotExpirable() {
        return this.cannotBeExpired;
    }

    public String toString() {
        return "WorkerDaemonClient{ log level=" + (Object)((Object)this.logLevel) + ", use count=" + this.uses + ", has failed=" + this.failed + ", can be expired=" + !this.cannotBeExpired + ", workerProcess=" + this.workerProcess + ", forkOptions=" + this.forkOptions + '}';
    }
}

