/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.net.URISyntaxException;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonMessageSerializer;
import org.gradle.workers.internal.WorkerDaemonProcess;
import org.gradle.workers.internal.WorkerProtocol;

public class WorkerDaemonStarter {
    private static final Logger LOG = Logging.getLogger(WorkerDaemonStarter.class);
    private final WorkerProcessFactory workerDaemonProcessFactory;
    private final LoggingManager loggingManager;
    private final ClassPathRegistry classPathRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public WorkerDaemonStarter(WorkerProcessFactory workerDaemonProcessFactory, LoggingManager loggingManager, ClassPathRegistry classPathRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerDaemonProcessFactory = workerDaemonProcessFactory;
        this.loggingManager = loggingManager;
        this.classPathRegistry = classPathRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    public WorkerDaemonClient startDaemon(Class<? extends WorkerProtocol> workerProtocolImplementationClass, DaemonForkOptions forkOptions, Action<WorkerProcess> cleanupAction) {
        LOG.debug("Starting Gradle worker daemon with fork options {}.", forkOptions);
        Timer clock = Time.startTimer();
        MultiRequestWorkerProcessBuilder<WorkerDaemonProcess> builder = this.workerDaemonProcessFactory.multiRequestWorker(WorkerDaemonProcess.class, WorkerProtocol.class, workerProtocolImplementationClass);
        builder.setBaseName("Gradle Worker Daemon");
        builder.setLogLevel(this.loggingManager.getLevel());
        builder.sharedPackages("org.gradle", "javax.inject");
        if (forkOptions.getClassLoaderStructure() instanceof FlatClassLoaderStructure) {
            FlatClassLoaderStructure flatClassLoaderStructure = (FlatClassLoaderStructure)forkOptions.getClassLoaderStructure();
            builder.applicationClasspath(this.classPathRegistry.getClassPath("MINIMUM_WORKER_RUNTIME").getAsFiles());
            builder.useApplicationClassloaderOnly();
            builder.applicationClasspath(WorkerDaemonStarter.toFiles(flatClassLoaderStructure.getSpec()));
        } else {
            builder.applicationClasspath(this.classPathRegistry.getClassPath("CORE_WORKER_RUNTIME").getAsFiles());
        }
        builder.onProcessFailure(cleanupAction);
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        forkOptions.getJavaForkOptions().copyTo(javaCommand);
        builder.registerArgumentSerializer(WorkerDaemonMessageSerializer.create());
        WorkerDaemonProcess workerDaemonProcess = builder.build();
        WorkerProcess workerProcess = workerDaemonProcess.start();
        WorkerDaemonClient client = new WorkerDaemonClient(forkOptions, workerDaemonProcess, workerProcess, this.loggingManager.getLevel(), this.actionExecutionSpecFactory);
        LOG.info("Started Gradle worker daemon ({}) with fork options {}.", clock.getElapsed(), forkOptions);
        return client;
    }

    private static Iterable<File> toFiles(VisitableURLClassLoader.Spec spec) {
        return CollectionUtils.collect(spec.getClasspath(), url -> {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        });
    }
}

