/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonSelectedQuery;
import org.fest.swing.driver.AbstractButtonTextQuery;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class AbstractButtonDriver
extends JComponentDriver
implements TextDisplayDriver<AbstractButton> {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull AbstractButton button, @Nullable String expected) {
        TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    public void requireText(@Nonnull AbstractButton button, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).matches(pattern);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public String textOf(@Nonnull AbstractButton button) {
        return AbstractButtonTextQuery.textOf(button);
    }

    @RunsInEDT
    public void select(@Nonnull AbstractButton button) {
        if (AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    public void deselect(@Nonnull AbstractButton button) {
        if (!AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    private static boolean checkSelected(final @Nonnull AbstractButton button) {
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            @Nullable
            protected Boolean executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(button);
                return button.isSelected();
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void requireSelected(@Nonnull AbstractButton button) {
        this.assertThatButtonIsSelected(button, true);
    }

    @RunsInEDT
    public void requireNotSelected(@Nonnull AbstractButton button) {
        this.assertThatButtonIsSelected(button, false);
    }

    @RunsInEDT
    private void assertThatButtonIsSelected(@Nonnull AbstractButton button, boolean selected) {
        ((BooleanAssert)Assertions.assertThat((boolean)AbstractButtonSelectedQuery.isSelected(button)).as(AbstractButtonDriver.selectedProperty(button))).isEqualTo(selected);
    }

    @Nonnull
    @RunsInEDT
    private static Description selectedProperty(@Nonnull AbstractButton button) {
        return AbstractButtonDriver.propertyName(button, SELECTED_PROPERTY);
    }
}

