/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JToolBar;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JToolBarDriver;
import org.fest.swing.fixture.AbstractSwingContainerFixture;

public class JToolBarFixture
extends AbstractSwingContainerFixture<JToolBarFixture, JToolBar, JToolBarDriver> {
    public JToolBarFixture(@Nonnull Robot robot, @Nonnull JToolBar target) {
        super(JToolBarFixture.class, robot, target);
    }

    public JToolBarFixture(@Nonnull Robot robot, @Nullable String toolbarName) {
        super(JToolBarFixture.class, robot, toolbarName, JToolBar.class);
    }

    @Override
    @Nonnull
    protected JToolBarDriver createDriver(@Nonnull Robot robot) {
        return new JToolBarDriver(robot);
    }

    @Nonnull
    public JToolBarFixture floatTo(@Nonnull Point point) {
        ((JToolBarDriver)this.driver()).floatTo((JToolBar)this.target(), point.x, point.y);
        return this;
    }

    @Nonnull
    public JToolBarFixture unfloat() {
        ((JToolBarDriver)this.driver()).unfloat((JToolBar)this.target());
        return this;
    }

    @Nonnull
    public JToolBarFixture unfloat(@Nonnull UnfloatConstraint constraint) {
        ((JToolBarDriver)this.driver()).unfloat((JToolBar)this.target(), constraint.value());
        return this;
    }

    public static enum UnfloatConstraint {
        NORTH("North"),
        EAST("East"),
        SOUTH("South"),
        WEST("West");

        private final String value;

        private UnfloatConstraint(String value) {
            this.value = value;
        }

        @Nonnull
        public String value() {
            return this.value;
        }
    }
}

