/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ParentFinder;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

public class ExistingHierarchy
implements ComponentHierarchy {
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;

    public ExistingHierarchy() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    @VisibleForTesting
    ExistingHierarchy(@Nonnull ParentFinder parentFinder, @Nonnull ChildrenFinder childrenFinder) {
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        ArrayList roots = Lists.newArrayList();
        for (Window w : windowMonitor.rootWindows()) {
            roots.add(w);
        }
        return roots;
    }

    @Override
    @RunsInCurrentThread
    public Container parentOf(@Nonnull Component c) {
        return this.parentFinder.parentOf(c);
    }

    @Override
    public boolean contains(@Nonnull Component c) {
        return true;
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        return this.childrenFinder.childrenOf(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (AWT.isAppletViewer(w)) {
            return;
        }
        for (Window owned : w.getOwnedWindows()) {
            if (owned == null) continue;
            this.dispose(owned);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        w.dispose();
    }

    @Nonnull
    ParentFinder parentFinder() {
        return this.parentFinder;
    }

    @Nonnull
    ChildrenFinder childrenFinder() {
        return this.childrenFinder;
    }
}

