/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.ExternalReferencesResult;
import com.intellij.filePrediction.FileNavigationLogger;
import com.intellij.filePrediction.FilePredictionFeaturesHelper;
import com.intellij.filePrediction.history.FilePredictionHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J0\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fJ,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/filePrediction/FileUsagePredictor;", "", "()V", "CALCULATE_CANDIDATE_PROBABILITY", "", "CALCULATE_OPEN_FILE_PROBABILITY", "MAX_CANDIDATE", "", "addWithLimit", "", "from", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "to", "", "skip", "limit", "calculateCandidates", "project", "Lcom/intellij/openapi/project/Project;", "prevFile", "openedFile", "refsComputation", "", "referencesResult", "Lcom/intellij/filePrediction/ExternalReferencesResult;", "calculateExternalReferences", "logFileFeatures", "newFile", "onFileOpened", "selectFileCandidates", "", "currentFile", "refs", "", "intellij.filePrediction"})
public final class FileUsagePredictor {
    private static final double CALCULATE_OPEN_FILE_PROBABILITY = 0.5;
    private static final double CALCULATE_CANDIDATE_PROBABILITY = 0.1;
    private static final int MAX_CANDIDATE = 10;
    public static final FileUsagePredictor INSTANCE;

    public final void onFileOpened(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        NonUrgentExecutor.getInstance().execute(new Runnable(project, newFile, prevFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $newFile;
            final /* synthetic */ VirtualFile $prevFile;

            public final void run() {
                if (Math.random() < 0.5) {
                    FileUsagePredictor.access$logFileFeatures(FileUsagePredictor.INSTANCE, this.$project, this.$newFile, this.$prevFile);
                }
                FilePredictionHistory filePredictionHistory = FilePredictionHistory.Companion.getInstance(this.$project);
                String string = this.$newFile.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newFile.url");
                filePredictionHistory.onFileOpened(string);
            }
            {
                this.$project = project;
                this.$newFile = virtualFile;
                this.$prevFile = virtualFile2;
            }
        });
    }

    private final void logFileFeatures(Project project, VirtualFile newFile, VirtualFile prevFile) {
        block1: {
            long start = System.currentTimeMillis();
            ExternalReferencesResult result = this.calculateExternalReferences(project, prevFile);
            long refsComputation = System.currentTimeMillis() - start;
            FileNavigationLogger.INSTANCE.logEvent(project, newFile, prevFile, "file.opened", refsComputation, result.contains(newFile));
            if (!(Math.random() < 0.1)) break block1;
            VirtualFile virtualFile = prevFile;
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile2;
                boolean bl3 = false;
                INSTANCE.calculateCandidates(project, it, newFile, refsComputation, result);
            }
        }
    }

    private final ExternalReferencesResult calculateExternalReferences(Project project, VirtualFile prevFile) {
        Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<ExternalReferencesResult>(prevFile, project){
            final /* synthetic */ VirtualFile $prevFile;
            final /* synthetic */ Project $project;

            @NotNull
            public final ExternalReferencesResult compute() {
                PsiFile prevPsiFile;
                PsiFile psiFile;
                VirtualFile virtualFile = this.$prevFile;
                if (virtualFile != null) {
                    if (!virtualFile.isValid()) {
                        return ExternalReferencesResult.Companion.getFAILED_COMPUTATION();
                    }
                }
                VirtualFile virtualFile2 = this.$prevFile;
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile3;
                    boolean bl3 = false;
                    psiFile = PsiManager.getInstance((Project)this.$project).findFile(it);
                } else {
                    psiFile = prevPsiFile = null;
                }
                if (DumbService.isDumb((Project)this.$project)) {
                    return ExternalReferencesResult.Companion.getFAILED_COMPUTATION();
                }
                return FilePredictionFeaturesHelper.INSTANCE.calculateExternalReferences(prevPsiFile);
            }
            {
                this.$prevFile = virtualFile;
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026ences(prevPsiFile)\n    })");
        return (ExternalReferencesResult)object;
    }

    private final void calculateCandidates(Project project, VirtualFile prevFile, VirtualFile openedFile, long refsComputation, ExternalReferencesResult referencesResult) {
        List<VirtualFile> candidates = this.selectFileCandidates(project, prevFile, referencesResult.getReferences());
        for (VirtualFile candidate : candidates) {
            if (!(Intrinsics.areEqual((Object)candidate, (Object)openedFile) ^ true)) continue;
            FileNavigationLogger.INSTANCE.logEvent(project, candidate, prevFile, "candidate.calculated", refsComputation, referencesResult.contains(candidate));
        }
    }

    private final List<VirtualFile> selectFileCandidates(Project project, VirtualFile currentFile, Set<? extends VirtualFile> refs) {
        Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<ArrayList<VirtualFile>>(refs, currentFile, project){
            final /* synthetic */ Set $refs;
            final /* synthetic */ VirtualFile $currentFile;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<VirtualFile> compute() {
                void var1_1;
                ArrayList<E> result = new ArrayList<E>();
                FileUsagePredictor.access$addWithLimit(FileUsagePredictor.INSTANCE, this.$refs.iterator(), result, this.$currentFile, 5);
                FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.$project);
                for (VirtualFile parent = this.$currentFile.getParent(); parent != null && parent.isDirectory() && result.size() < 10 && fileIndex.isInProjectScope(parent); parent = parent.getParent()) {
                    FileUsagePredictor.access$addWithLimit(FileUsagePredictor.INSTANCE, ArrayIteratorKt.iterator((Object[])parent.getChildren()), result, this.$currentFile, 10);
                }
                return var1_1;
            }
            {
                this.$refs = set;
                this.$currentFile = virtualFile;
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026    }\n      result\n    })");
        return (List)object;
    }

    private final void addWithLimit(Iterator<? extends VirtualFile> from, List<VirtualFile> to, VirtualFile skip, int limit) {
        while (to.size() < limit && from.hasNext()) {
            VirtualFile next = from.next();
            if (next.isDirectory() || !(Intrinsics.areEqual((Object)skip, (Object)next) ^ true)) continue;
            to.add(next);
        }
    }

    private FileUsagePredictor() {
    }

    static {
        FileUsagePredictor fileUsagePredictor;
        INSTANCE = fileUsagePredictor = new FileUsagePredictor();
    }

    public static final /* synthetic */ void access$logFileFeatures(FileUsagePredictor $this, Project project, VirtualFile newFile, VirtualFile prevFile) {
        $this.logFileFeatures(project, newFile, prevFile);
    }

    public static final /* synthetic */ void access$addWithLimit(FileUsagePredictor $this, Iterator from, List to, VirtualFile skip, int limit) {
        $this.addWithLimit(from, to, skip, limit);
    }
}

