/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;

public class DaemonStartupCommunication {
    private static final Logger LOGGER = Logging.getLogger(DaemonStartupCommunication.class);

    public void printDaemonStarted(PrintStream target, Long pid, String uid, Address address, File daemonLog) {
        target.print(DaemonStartupCommunication.daemonGreeting());
        try {
            EncodedStream.EncodedOutput outputStream = new EncodedStream.EncodedOutput((OutputStream)target);
            OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)outputStream);
            encoder.writeNullableString((CharSequence)(pid == null ? null : pid.toString()));
            encoder.writeString((CharSequence)uid);
            MultiChoiceAddress multiChoiceAddress = (MultiChoiceAddress)address;
            new MultiChoiceAddressSerializer().write((Encoder)encoder, multiChoiceAddress);
            encoder.writeString((CharSequence)daemonLog.getPath());
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        target.println();
        LOGGER.debug("Completed writing the daemon greeting. Closing streams...");
    }

    public DaemonStartupInfo readDiagnostics(String message) {
        if (!message.startsWith(DaemonStartupCommunication.daemonGreeting())) {
            throw new IllegalArgumentException(String.format("Unexpected daemon startup message: %s", message));
        }
        try {
            String encoded = message.substring(DaemonStartupCommunication.daemonGreeting().length()).trim();
            EncodedStream.EncodedInput inputStream = new EncodedStream.EncodedInput((InputStream)new ByteArrayInputStream(encoded.getBytes()));
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder((InputStream)inputStream);
            String pidString = decoder.readNullableString();
            String uid = decoder.readString();
            Long pid = pidString == null ? null : Long.valueOf(pidString);
            MultiChoiceAddress address = new MultiChoiceAddressSerializer().read((Decoder)decoder);
            File daemonLog = new File(decoder.readString());
            return new DaemonStartupInfo(uid, (Address)address, new DaemonDiagnostics(daemonLog, pid));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public boolean containsGreeting(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Unable to detect the daemon greeting because the input message is null!");
        }
        return message.contains(DaemonStartupCommunication.daemonGreeting());
    }

    private static String daemonGreeting() {
        return "Daemon started. About to close the streams. Daemon details: ";
    }
}

