/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.scene.input.MouseEvent;

public class EditorPlatform {
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    public static final boolean IS_LINUX = osName.contains("linux");
    public static final boolean IS_MAC = osName.contains("mac");
    public static final boolean IS_WINDOWS = osName.contains("windows");
    public static final String DOCUMENTATION_URL = "https://docs.oracle.com/javafx/index.html";
    public static final String JAVADOC_HOME = "https://docs.oracle.com/javase/8/javafx/api/";

    public static String getThemeStylesheetURL(Theme theme) {
        String result;
        switch (theme) {
            default: {
                result = null;
                break;
            }
            case MODENA: {
                result = "com/sun/javafx/scene/control/skin/modena/modena.bss";
                break;
            }
            case MODENA_TOUCH: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch.css";
                break;
            }
            case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-blackOnWhite.css";
                break;
            }
            case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-whiteOnBlack.css";
                break;
            }
            case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-yellowOnBlack.css";
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-blackOnWhite.css";
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-whiteOnBlack.css";
                break;
            }
            case MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-yellowOnBlack.css";
                break;
            }
            case CASPIAN: {
                result = "com/sun/javafx/scene/control/skin/caspian/caspian.bss";
                break;
            }
            case CASPIAN_HIGH_CONTRAST: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-highContrast.css";
                break;
            }
            case CASPIAN_EMBEDDED: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded.css";
                break;
            }
            case CASPIAN_EMBEDDED_HIGH_CONTRAST: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-highContrast.css";
                break;
            }
            case CASPIAN_EMBEDDED_QVGA: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-qvga.css";
                break;
            }
            case CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST: {
                result = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-qvga-highContrast.css";
            }
        }
        if (!theme.equals((Object)Theme.MODENA)) assert (result != null) : "Missing logic for " + (Object)((Object)theme);
        return result;
    }

    public static String getPlatformThemeStylesheetURL() {
        return "com/sun/javafx/scene/control/skin/modena/modena.bss";
    }

    public static boolean isModena(Theme theme) {
        return theme.toString().startsWith("MODENA");
    }

    public static boolean isModenaBlackonwhite(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("BLACK_ON_WHITE");
    }

    public static boolean isModenaWhiteonblack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("WHITE_ON_BLACK");
    }

    public static boolean isModenaYellowonblack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("YELLOW_ON_BLACK");
    }

    public static boolean isModenaHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST");
    }

    public static boolean isModenaTouch(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("TOUCH");
    }

    public static boolean isModenaTouchHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST") && theme.toString().contains("TOUCH");
    }

    public static boolean isCaspian(Theme theme) {
        return theme.toString().startsWith("CASPIAN");
    }

    public static void open(String path) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (IS_MAC) {
            args.add("open");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("cmd");
            args.add("/c");
            args.add("start");
            if (path.contains(" ")) {
                args.add("\"html\"");
            }
            args.add(path);
        } else if (IS_LINUX) {
            args.add("xdg-open");
            args.add(path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null);
        }
    }

    public static void revealInFileBrowser(File filePath) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String path = filePath.toURI().toURL().toExternalForm();
        if (IS_MAC) {
            args.add("open");
            args.add("-R");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("explorer");
            args.add("/select," + path);
        } else if (IS_LINUX) {
            args.add("nautilus");
            int osVersionNumerical = Integer.parseInt(System.getProperty("os.version").substring(0, 1));
            if (osVersionNumerical < 3 && (path = filePath.getAbsoluteFile().getParent()) == null) {
                path = ".";
            }
            args.add(path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null);
        }
    }

    public static boolean isContinuousSelectKeyDown(MouseEvent e) {
        return e.isShiftDown();
    }

    public static boolean isNonContinousSelectKeyDown(MouseEvent e) {
        return IS_MAC ? e.isMetaDown() : e.isControlDown();
    }

    public static boolean isAssertionEnabled() {
        return EditorPlatform.class.desiredAssertionStatus();
    }

    private static void executeDaemon(List<String> cmd, File wDir) throws IOException {
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder = builder.directory(wDir);
            builder.start();
        }
        catch (RuntimeException ex) {
            throw new IOException(ex);
        }
    }

    public static enum Theme {
        MODENA,
        MODENA_TOUCH,
        MODENA_HIGH_CONTRAST_BLACK_ON_WHITE,
        MODENA_HIGH_CONTRAST_WHITE_ON_BLACK,
        MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK,
        MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE,
        MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK,
        MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK,
        CASPIAN,
        CASPIAN_HIGH_CONTRAST,
        CASPIAN_EMBEDDED,
        CASPIAN_EMBEDDED_HIGH_CONTRAST,
        CASPIAN_EMBEDDED_QVGA,
        CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;

    }
}

