/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexColumnContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.scene.layout.ColumnConstraints;

public class MoveColumnJob
extends BatchSelectionJob {
    private FXOMObject targetGridPane;
    private final List<Integer> targetIndexes = new ArrayList<Integer>();
    private final GridPaneJobUtils.Position position;

    public MoveColumnJob(EditorController editorController, GridPaneJobUtils.Position position) {
        super(editorController);
        assert (position == GridPaneJobUtils.Position.BEFORE || position == GridPaneJobUtils.Position.AFTER);
        this.position = position;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (GridPaneJobUtils.canPerformMove(this.getEditorController(), this.position)) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            this.targetGridPane = gsg.getParentObject();
            this.targetIndexes.addAll(gsg.getIndexes());
            result.addAll(this.moveColumnConstraints());
            result.addAll(this.moveColumnContent());
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Move Column " + this.position.name();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        HashSet<Integer> movedIndexes = new HashSet<Integer>();
        for (int targetIndex : this.targetIndexes) {
            int movedIndex = this.position == GridPaneJobUtils.Position.BEFORE ? targetIndex - 1 : targetIndex + 1;
            movedIndexes.add(movedIndex);
        }
        return new GridSelectionGroup(this.targetGridPane, GridSelectionGroup.Type.COLUMN, movedIndexes);
    }

    private List<Job> moveColumnConstraints() {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName propertyName = new PropertyName("columnConstraints");
        assert (this.targetGridPane instanceof FXOMInstance);
        FXOMProperty constraintsProperty = ((FXOMInstance)this.targetGridPane).getProperties().get(propertyName);
        if (constraintsProperty == null) {
            return result;
        }
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            FXOMObject beforeConstraints;
            int positionIndex;
            switch (this.position) {
                case BEFORE: {
                    positionIndex = targetIndex - 1;
                    break;
                }
                case AFTER: {
                    positionIndex = targetIndex + 1;
                    break;
                }
                default: {
                    assert (false);
                    return result;
                }
            }
            FXOMObject targetConstraints = mask.getColumnConstraintsAtIndex(targetIndex);
            if (targetConstraints != null) {
                RemoveObjectJob removeValueJob = new RemoveObjectJob(targetConstraints, this.getEditorController());
                result.add(removeValueJob);
                AddPropertyValueJob addValueJob = new AddPropertyValueJob(targetConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
                result.add(addValueJob);
                continue;
            }
            if (this.position != GridPaneJobUtils.Position.BEFORE || (beforeConstraints = mask.getColumnConstraintsAtIndex(targetIndex - 1)) == null) continue;
            FXOMInstance addedConstraints = this.makeColumnConstraintsInstance();
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
            result.add(addValueJob);
        }
        return result;
    }

    private List<Job> moveColumnContent() {
        ArrayList<Job> result = new ArrayList<Job>();
        block4: for (int targetIndex : this.targetIndexes) {
            switch (this.position) {
                case BEFORE: {
                    result.add(new ReIndexColumnContentJob(this.getEditorController(), -1, this.targetGridPane, targetIndex));
                    int beforeIndex = targetIndex - 1;
                    if (this.targetIndexes.contains(beforeIndex)) continue block4;
                    int shiftIndex = 1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        ++shiftIndex;
                    }
                    result.add(new ReIndexColumnContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, beforeIndex));
                    continue block4;
                }
                case AFTER: {
                    result.add(new ReIndexColumnContentJob(this.getEditorController(), 1, this.targetGridPane, targetIndex));
                    int afterIndex = targetIndex + 1;
                    if (this.targetIndexes.contains(afterIndex)) continue block4;
                    int shiftIndex = -1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        --shiftIndex;
                    }
                    result.add(new ReIndexColumnContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, afterIndex));
                    continue block4;
                }
            }
            assert (false);
        }
        return result;
    }

    private FXOMInstance makeColumnConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, ColumnConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }
}

