/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.scene.layout.RowConstraints;

public class MoveRowJob
extends BatchSelectionJob {
    private FXOMObject targetGridPane;
    private final List<Integer> targetIndexes = new ArrayList<Integer>();
    private final GridPaneJobUtils.Position position;

    public MoveRowJob(EditorController editorController, GridPaneJobUtils.Position position) {
        super(editorController);
        assert (position == GridPaneJobUtils.Position.ABOVE || position == GridPaneJobUtils.Position.BELOW);
        this.position = position;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (GridPaneJobUtils.canPerformMove(this.getEditorController(), this.position)) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            this.targetGridPane = gsg.getParentObject();
            this.targetIndexes.addAll(gsg.getIndexes());
            result.addAll(this.moveRowConstraints());
            result.addAll(this.moveRowContent());
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Move Row " + this.position.name();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        HashSet<Integer> movedIndexes = new HashSet<Integer>();
        for (int targetIndex : this.targetIndexes) {
            int movedIndex = this.position == GridPaneJobUtils.Position.ABOVE ? targetIndex - 1 : targetIndex + 1;
            movedIndexes.add(movedIndex);
        }
        return new GridSelectionGroup(this.targetGridPane, GridSelectionGroup.Type.ROW, movedIndexes);
    }

    private List<Job> moveRowConstraints() {
        ArrayList<Job> result = new ArrayList<Job>();
        PropertyName propertyName = new PropertyName("rowConstraints");
        assert (this.targetGridPane instanceof FXOMInstance);
        FXOMProperty constraintsProperty = ((FXOMInstance)this.targetGridPane).getProperties().get(propertyName);
        if (constraintsProperty == null) {
            return result;
        }
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            FXOMObject aboveConstraints;
            int positionIndex;
            switch (this.position) {
                case ABOVE: {
                    positionIndex = targetIndex - 1;
                    break;
                }
                case BELOW: {
                    positionIndex = targetIndex + 1;
                    break;
                }
                default: {
                    assert (false);
                    return result;
                }
            }
            FXOMObject targetConstraints = mask.getRowConstraintsAtIndex(targetIndex);
            if (targetConstraints != null) {
                RemoveObjectJob removeValueJob = new RemoveObjectJob(targetConstraints, this.getEditorController());
                result.add(removeValueJob);
                AddPropertyValueJob addValueJob = new AddPropertyValueJob(targetConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
                result.add(addValueJob);
                continue;
            }
            if (this.position != GridPaneJobUtils.Position.ABOVE || (aboveConstraints = mask.getRowConstraintsAtIndex(targetIndex - 1)) == null) continue;
            FXOMInstance addedConstraints = this.makeRowConstraintsInstance();
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
            result.add(addValueJob);
        }
        return result;
    }

    private List<Job> moveRowContent() {
        ArrayList<Job> result = new ArrayList<Job>();
        block4: for (int targetIndex : this.targetIndexes) {
            switch (this.position) {
                case ABOVE: {
                    result.add(new ReIndexRowContentJob(this.getEditorController(), -1, this.targetGridPane, targetIndex));
                    int aboveIndex = targetIndex - 1;
                    if (this.targetIndexes.contains(aboveIndex)) continue block4;
                    int shiftIndex = 1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        ++shiftIndex;
                    }
                    result.add(new ReIndexRowContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, aboveIndex));
                    continue block4;
                }
                case BELOW: {
                    result.add(new ReIndexRowContentJob(this.getEditorController(), 1, this.targetGridPane, targetIndex));
                    int belowIndex = targetIndex + 1;
                    if (this.targetIndexes.contains(belowIndex)) continue block4;
                    int shiftIndex = -1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        --shiftIndex;
                    }
                    result.add(new ReIndexRowContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, belowIndex));
                    continue block4;
                }
            }
            assert (false);
        }
        return result;
    }

    private FXOMInstance makeRowConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, RowConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }
}

