/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.Quad;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ColorEncoder;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;

class GridPaneMosaic {
    public static final double NORTH_TRAY_SIZE = 22.0;
    public static final double SOUTH_TRAY_SIZE = 22.0;
    public static final double WEST_TRAY_SIZE = 24.0;
    public static final double EAST_TRAY_SIZE = 24.0;
    private final Group topGroup = new Group();
    private final Path gridPath = new Path();
    private final Group hgapLinesGroup = new Group();
    private final Group vgapLinesGroup = new Group();
    private final Group northTrayGroup = new Group();
    private final Group southTrayGroup = new Group();
    private final Group westTrayGroup = new Group();
    private final Group eastTrayGroup = new Group();
    private final Rectangle targetCellShadow = new Rectangle();
    private final Line targetGapShadowV = new Line();
    private final Line targetGapShadowH = new Line();
    private final Group hgapSensorsGroup = new Group();
    private final Group vgapSensorsGroup = new Group();
    private final Quad gridAreaQuad = new Quad();
    private final List<Quad> gridHoleQuads = new ArrayList<Quad>();
    private final String baseStyleClass;
    private final boolean shouldShowTrays;
    private final boolean shouldCreateSensors;
    private GridPane gridPane;
    private int columnCount;
    private int rowCount;
    private List<Bounds> cellBounds = new ArrayList<Bounds>();
    private final Set<Integer> selectedColumnIndexes = new HashSet<Integer>();
    private final Set<Integer> selectedRowIndexes = new HashSet<Integer>();
    private int targetColumnIndex = -1;
    private int targetRowIndex = -1;
    private int targetGapColumnIndex = -1;
    private int targetGapRowIndex = -1;
    private Color trayColor;
    private static final double MIN_STROKE_WIDTH = 8.0;

    public GridPaneMosaic(String baseStyleClass, boolean shouldShowTrays, boolean shouldCreateSensors) {
        assert (baseStyleClass != null);
        this.baseStyleClass = baseStyleClass;
        this.shouldShowTrays = shouldShowTrays;
        this.shouldCreateSensors = shouldCreateSensors;
        ObservableList topChildren = this.topGroup.getChildren();
        topChildren.add(this.gridPath);
        topChildren.add(this.hgapLinesGroup);
        topChildren.add(this.vgapLinesGroup);
        topChildren.add(this.northTrayGroup);
        topChildren.add(this.southTrayGroup);
        topChildren.add(this.westTrayGroup);
        topChildren.add(this.eastTrayGroup);
        topChildren.add(this.targetCellShadow);
        topChildren.add(this.targetGapShadowV);
        topChildren.add(this.targetGapShadowH);
        topChildren.add(this.hgapSensorsGroup);
        topChildren.add(this.vgapSensorsGroup);
        this.gridAreaQuad.addToPath(this.gridPath);
        this.gridPath.setMouseTransparent(true);
        this.gridPath.getStyleClass().add((Object)"gap");
        this.gridPath.getStyleClass().add((Object)baseStyleClass);
        this.hgapLinesGroup.setMouseTransparent(true);
        this.vgapLinesGroup.setMouseTransparent(true);
        this.targetCellShadow.setMouseTransparent(true);
        this.targetCellShadow.getStyleClass().add((Object)"gap");
        this.targetCellShadow.getStyleClass().add((Object)"selected");
        this.targetCellShadow.getStyleClass().add((Object)baseStyleClass);
        this.targetGapShadowV.setMouseTransparent(true);
        this.targetGapShadowV.getStyleClass().add((Object)"gap");
        this.targetGapShadowV.getStyleClass().add((Object)"hilit");
        this.targetGapShadowV.getStyleClass().add((Object)baseStyleClass);
        this.targetGapShadowH.setMouseTransparent(true);
        this.targetGapShadowH.getStyleClass().add((Object)"gap");
        this.targetGapShadowH.getStyleClass().add((Object)"hilit");
        this.targetGapShadowH.getStyleClass().add((Object)baseStyleClass);
    }

    public Group getTopGroup() {
        return this.topGroup;
    }

    public GridPane getGridPane() {
        return this.gridPane;
    }

    public void setGridPane(GridPane gridPane) {
        this.gridPane = gridPane;
        this.update();
    }

    public void setTrayColor(Color trayColor) {
        this.trayColor = trayColor;
        if (this.shouldShowTrays) {
            this.updateTrayColor();
        }
    }

    public void setSelectedColumnIndexes(Set<Integer> indexes) {
        this.selectedColumnIndexes.clear();
        this.selectedColumnIndexes.addAll(indexes);
        this.update();
    }

    public void setSelectedRowIndexes(Set<Integer> indexes) {
        this.selectedRowIndexes.clear();
        this.selectedRowIndexes.addAll(indexes);
        this.update();
    }

    public void setTargetCell(int targetColumnIndex, int targetRowIndex) {
        assert (targetColumnIndex == -1 == (targetRowIndex == -1));
        this.targetColumnIndex = targetColumnIndex;
        this.targetRowIndex = targetRowIndex;
        this.targetGapColumnIndex = -1;
        this.targetGapRowIndex = -1;
        this.update();
    }

    public void setTargetGap(int targetGapColumnIndex, int targetGapRowIndex) {
        assert (-1 <= targetGapColumnIndex && targetGapColumnIndex <= this.columnCount);
        assert (-1 <= targetGapRowIndex && targetGapRowIndex <= this.rowCount);
        this.targetGapColumnIndex = targetGapColumnIndex;
        this.targetGapRowIndex = targetGapRowIndex;
        this.targetColumnIndex = -1;
        this.targetRowIndex = -1;
        this.update();
    }

    public void update() {
        this.columnCount = Deprecation.getGridPaneColumnCount(this.gridPane);
        this.rowCount = Deprecation.getGridPaneRowCount(this.gridPane);
        if (this.columnCount == 0 || this.rowCount == 0) {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        this.cellBounds.clear();
        for (int c = 0; c < this.columnCount; ++c) {
            for (int r = 0; r < this.rowCount; ++r) {
                this.cellBounds.add(Deprecation.getGridPaneCellBounds(this.gridPane, c, r));
            }
        }
        this.gridAreaQuad.setBounds(this.gridPane.getLayoutBounds());
        this.adjustHoleItems();
        this.adjustHGapLines();
        this.adjustVGapLines();
        if (this.shouldShowTrays) {
            this.adjustTrayItems((List<Node>)this.northTrayGroup.getChildren(), "north", this.columnCount);
            this.adjustTrayItems((List<Node>)this.southTrayGroup.getChildren(), "south", this.columnCount);
            this.adjustTrayItems((List<Node>)this.westTrayGroup.getChildren(), "west", this.rowCount);
            this.adjustTrayItems((List<Node>)this.eastTrayGroup.getChildren(), "east", this.rowCount);
        }
        if (this.shouldCreateSensors) {
            int hgapSensorCount = Math.max(0, this.columnCount - 1);
            int vgapSensorCount = Math.max(0, this.rowCount - 1);
            this.adjustGapSensors((List<Node>)this.hgapSensorsGroup.getChildren(), Cursor.H_RESIZE, hgapSensorCount);
            this.adjustGapSensors((List<Node>)this.vgapSensorsGroup.getChildren(), Cursor.V_RESIZE, vgapSensorCount);
        }
        if (this.columnCount >= 1) {
            assert (this.rowCount >= 1);
            this.updateHoleBounds();
            this.updateHGapLines();
            this.updateVGapLines();
            if (this.shouldShowTrays) {
                this.updateNorthTrayBounds();
                this.updateSouthTrayBounds();
                this.updateWestTrayBounds();
                this.updateEastTrayBounds();
                this.updateSelection((List<Node>)this.northTrayGroup.getChildren(), this.selectedColumnIndexes);
                this.updateSelection((List<Node>)this.southTrayGroup.getChildren(), this.selectedColumnIndexes);
                this.updateSelection((List<Node>)this.westTrayGroup.getChildren(), this.selectedRowIndexes);
                this.updateSelection((List<Node>)this.eastTrayGroup.getChildren(), this.selectedRowIndexes);
                this.updateTrayColor();
            }
            if (this.shouldCreateSensors) {
                this.updateHGapSensors();
                this.updateVGapSensors();
            }
            this.updateTargetCell();
            this.updateTargetGap();
        }
    }

    public List<Node> getNorthTrayNodes() {
        return this.northTrayGroup.getChildren();
    }

    public List<Node> getSouthTrayNodes() {
        return this.southTrayGroup.getChildren();
    }

    public List<Node> getWestTrayNodes() {
        return this.westTrayGroup.getChildren();
    }

    public List<Node> getEastTrayNodes() {
        return this.eastTrayGroup.getChildren();
    }

    public List<Node> getHgapSensorNodes() {
        return this.hgapSensorsGroup.getChildren();
    }

    public List<Node> getVgapSensorNodes() {
        return this.vgapSensorsGroup.getChildren();
    }

    private void adjustHoleItems() {
        int holeCount = this.columnCount * this.rowCount;
        while (this.gridHoleQuads.size() < holeCount) {
            Quad holeQuad = new Quad(false);
            holeQuad.addToPath(this.gridPath);
            this.gridHoleQuads.add(holeQuad);
        }
        while (holeCount < this.gridHoleQuads.size()) {
            int cellIndex = this.gridHoleQuads.size() - 1;
            this.gridHoleQuads.get(cellIndex).removeFromPath(this.gridPath);
            this.gridHoleQuads.remove(cellIndex);
        }
    }

    private void adjustHGapLines() {
        int hgapLineCount = this.gridPane.getHgap() == 0.0 ? Math.max(0, this.columnCount - 1) : 0;
        ObservableList children = this.hgapLinesGroup.getChildren();
        while (children.size() < hgapLineCount) {
            children.add(this.makeGapLine());
        }
        while (children.size() > hgapLineCount) {
            children.remove(0);
        }
    }

    private void adjustVGapLines() {
        int vgapLineCount = this.gridPane.getVgap() == 0.0 ? Math.max(0, this.rowCount - 1) : 0;
        ObservableList children = this.vgapLinesGroup.getChildren();
        while (children.size() < vgapLineCount) {
            children.add(this.makeGapLine());
        }
        while (children.size() > vgapLineCount) {
            children.remove(0);
        }
    }

    private Line makeGapLine() {
        Line result = new Line();
        result.getStyleClass().add((Object)"gap");
        result.getStyleClass().add((Object)"empty");
        result.getStyleClass().add((Object)this.baseStyleClass);
        return result;
    }

    private void adjustTrayItems(List<Node> trayChildren, String direction, int targetCount) {
        int trayIndex;
        while (trayChildren.size() < targetCount) {
            trayIndex = trayChildren.size();
            trayChildren.add((Node)this.makeTrayLabel(trayIndex, direction));
        }
        while (targetCount < trayChildren.size()) {
            trayIndex = trayChildren.size() - 1;
            trayChildren.remove(trayIndex);
        }
    }

    private Label makeTrayLabel(int num, String direction) {
        Label result = new Label();
        result.getStyleClass().add((Object)"tray");
        result.getStyleClass().add((Object)direction);
        result.getStyleClass().add((Object)this.baseStyleClass);
        result.setText(String.valueOf(num));
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setMaxWidth(Double.NEGATIVE_INFINITY);
        result.setMinHeight(Double.NEGATIVE_INFINITY);
        result.setMaxHeight(Double.NEGATIVE_INFINITY);
        if (this.trayColor != null) {
            String webColor = ColorEncoder.encodeColorToRGBA(this.trayColor);
            String style = "-fx-background-color:" + webColor + ";";
            result.setStyle(style);
        }
        return result;
    }

    private void updateTrayColor() {
        String style;
        if (this.trayColor == null) {
            style = "";
        } else {
            String webColor = ColorEncoder.encodeColorToRGBA(this.trayColor);
            style = "-fx-background-color:" + webColor + ";";
        }
        this.adjustTrayStyle((List<Node>)this.northTrayGroup.getChildren(), style);
        this.adjustTrayStyle((List<Node>)this.southTrayGroup.getChildren(), style);
        this.adjustTrayStyle((List<Node>)this.westTrayGroup.getChildren(), style);
        this.adjustTrayStyle((List<Node>)this.eastTrayGroup.getChildren(), style);
    }

    private void adjustTrayStyle(List<Node> trayChildren, String style) {
        for (Node tray : trayChildren) {
            assert (tray instanceof Label);
            Label trayLabel = (Label)tray;
            trayLabel.setStyle(style);
        }
    }

    private void adjustGapSensors(List<Node> gapSensors, Cursor cursor, int targetCount) {
        while (gapSensors.size() < targetCount) {
            gapSensors.add((Node)this.makeGapSensor(cursor));
        }
        while (targetCount < gapSensors.size()) {
            int gapIndex = gapSensors.size() - 1;
            gapSensors.remove(gapIndex);
        }
    }

    private Line makeGapSensor(Cursor cursor) {
        Line result = new Line();
        result.setCursor(cursor);
        result.setStroke((Paint)Color.TRANSPARENT);
        return result;
    }

    private void updateHGapSensors() {
        ObservableList children = this.hgapSensorsGroup.getChildren();
        int sensorCount = children.size();
        assert (sensorCount == 0 || sensorCount == this.columnCount - 1);
        for (int i = 0; i < sensorCount; ++i) {
            Bounds topLeftCellBounds = this.getCellBounds(i, 0);
            Bounds topRightCellBounds = this.getCellBounds(i + 1, 0);
            Bounds bottomLeftCellBounds = this.getCellBounds(i, this.rowCount - 1);
            double x0 = topLeftCellBounds.getMaxX();
            double x1 = topRightCellBounds.getMinX();
            double xm = (x0 + x1) / 2.0;
            double y0 = topLeftCellBounds.getMinY();
            double y1 = bottomLeftCellBounds.getMaxY();
            double strokeWidth = Math.max(8.0, x1 - x0);
            Line line = (Line)children.get(i);
            line.setStartX(xm);
            line.setStartY(y0);
            line.setEndX(xm);
            line.setEndY(y1);
            line.setStrokeWidth(strokeWidth);
        }
    }

    private void updateVGapSensors() {
        ObservableList children = this.vgapSensorsGroup.getChildren();
        int sensorCount = children.size();
        assert (sensorCount == 0 || sensorCount == this.rowCount - 1);
        for (int i = 0; i < sensorCount; ++i) {
            Bounds topLeftCellBounds = this.getCellBounds(0, i);
            Bounds bottomLeftCellBounds = this.getCellBounds(0, i + 1);
            Bounds topRightCellBounds = this.getCellBounds(this.columnCount - 1, i);
            double x0 = topLeftCellBounds.getMinX();
            double x1 = topRightCellBounds.getMaxX();
            double y0 = topLeftCellBounds.getMaxY();
            double y1 = bottomLeftCellBounds.getMinY();
            double ym = (y0 + y1) / 2.0;
            double strokeWidth = Math.max(8.0, y1 - y0);
            Line line = (Line)children.get(i);
            line.setStartX(x0);
            line.setStartY(ym);
            line.setEndX(x1);
            line.setEndY(ym);
            line.setStrokeWidth(strokeWidth);
        }
    }

    private void updateHoleBounds() {
        for (int c = 0; c < this.columnCount; ++c) {
            for (int r = 0; r < this.rowCount; ++r) {
                Bounds cb = this.getCellBounds(c, r);
                this.gridHoleQuads.get(this.getCellIndex(c, r)).setBounds(cb);
            }
        }
    }

    private void updateHGapLines() {
        ObservableList children = this.hgapLinesGroup.getChildren();
        int lineCount = children.size();
        assert (lineCount == 0 || lineCount == this.columnCount - 1);
        for (int i = 0; i < lineCount; ++i) {
            Bounds topLeftCellBounds = this.getCellBounds(i, 0);
            Bounds topRightCellBounds = this.getCellBounds(i + 1, 0);
            Bounds bottomLeftCellBounds = this.getCellBounds(i, this.rowCount - 1);
            double startX = (topLeftCellBounds.getMaxX() + topRightCellBounds.getMinX()) / 2.0;
            double startY = topLeftCellBounds.getMinY();
            double endY = bottomLeftCellBounds.getMaxY();
            double snappedX = (double)Math.round(startX) + 0.5;
            Line line = (Line)children.get(i);
            line.setStartX(snappedX);
            line.setStartY(startY);
            line.setEndX(snappedX);
            line.setEndY(endY);
        }
    }

    private void updateVGapLines() {
        ObservableList children = this.vgapLinesGroup.getChildren();
        int lineCount = children.size();
        assert (lineCount == 0 || lineCount == this.rowCount - 1);
        for (int i = 0; i < lineCount; ++i) {
            Bounds topLeftCellBounds = this.getCellBounds(0, i);
            Bounds bottomLeftCellBounds = this.getCellBounds(0, i + 1);
            Bounds topRightCellBounds = this.getCellBounds(this.columnCount - 1, i);
            double startX = topLeftCellBounds.getMinX();
            double startY = (topLeftCellBounds.getMaxY() + bottomLeftCellBounds.getMinY()) / 2.0;
            double endX = topRightCellBounds.getMaxX();
            double snappedY = (double)Math.round(startY) + 0.5;
            Line line = (Line)children.get(i);
            line.setStartX(startX);
            line.setStartY(snappedY);
            line.setEndX(endX);
            line.setEndY(snappedY);
        }
    }

    private void updateNorthTrayBounds() {
        ObservableList northTrayChildren = this.northTrayGroup.getChildren();
        assert (northTrayChildren.size() == this.columnCount);
        for (int c = 0; c < this.columnCount; ++c) {
            this.updateNorthTrayBounds(c, (Label)northTrayChildren.get(c));
        }
    }

    private void updateNorthTrayBounds(int column, Label label) {
        Bounds gb = this.gridPane.getLayoutBounds();
        Bounds cb = this.getCellBounds(column, 0);
        double x0 = cb.getMinX();
        double x1 = cb.getMaxX();
        double y0 = gb.getMinY();
        double y1 = cb.getMaxY();
        assert (x0 <= x1);
        assert (y0 <= y1);
        label.setPrefWidth(x1 - x0);
        label.setPrefHeight(22.0);
        BoundingBox area = new BoundingBox(x0, y0, x1 - x0, y1 - y0);
        this.relocateNode(label, (Bounds)area, CardinalPoint.N);
    }

    private void updateSouthTrayBounds() {
        ObservableList trayChildren = this.southTrayGroup.getChildren();
        assert (trayChildren.size() == this.columnCount);
        for (int c = 0; c < this.columnCount; ++c) {
            this.updateSouthTrayBounds(c, (Label)trayChildren.get(c));
        }
    }

    private void updateSouthTrayBounds(int column, Label label) {
        Bounds gb = this.gridPane.getLayoutBounds();
        Bounds cb = this.getCellBounds(column, 0);
        double x0 = cb.getMinX();
        double x1 = cb.getMaxX();
        double y0 = cb.getMinY();
        double y1 = gb.getMaxY();
        assert (x0 <= x1);
        assert (y0 <= y1);
        label.setPrefWidth(x1 - x0);
        label.setPrefHeight(22.0);
        BoundingBox area = new BoundingBox(x0, y0, x1 - x0, y1 - y0);
        this.relocateNode(label, (Bounds)area, CardinalPoint.S);
    }

    private void updateWestTrayBounds() {
        ObservableList trayChildren = this.westTrayGroup.getChildren();
        assert (trayChildren.size() == this.rowCount);
        for (int r = 0; r < this.rowCount; ++r) {
            this.updateWestTrayBounds(r, (Label)trayChildren.get(r));
        }
    }

    private void updateWestTrayBounds(int row, Label label) {
        Bounds gb = this.gridPane.getLayoutBounds();
        Bounds cb = this.getCellBounds(0, row);
        double x0 = gb.getMinX();
        double x1 = cb.getMaxX();
        double y0 = cb.getMinY();
        double y1 = cb.getMaxY();
        assert (x0 <= x1);
        assert (y0 <= y1);
        label.setPrefWidth(y1 - y0);
        label.setPrefHeight(24.0);
        BoundingBox area = new BoundingBox(x0, y0, x1 - x0, y1 - y0);
        this.relocateNode(label, (Bounds)area, CardinalPoint.W);
    }

    private void updateEastTrayBounds() {
        ObservableList trayChildren = this.eastTrayGroup.getChildren();
        assert (trayChildren.size() == this.rowCount);
        for (int r = 0; r < this.rowCount; ++r) {
            this.updateEastTrayBounds(r, (Label)trayChildren.get(r));
        }
    }

    private void updateEastTrayBounds(int row, Label label) {
        Bounds gb = this.gridPane.getLayoutBounds();
        Bounds cb = this.getCellBounds(0, row);
        double x0 = cb.getMinX();
        double x1 = gb.getMaxX();
        double y0 = cb.getMinY();
        double y1 = cb.getMaxY();
        assert (x0 <= x1);
        assert (y0 <= y1);
        label.setPrefWidth(y1 - y0);
        label.setPrefHeight(24.0);
        BoundingBox area = new BoundingBox(x0, y0, x1 - x0, y1 - y0);
        this.relocateNode(label, (Bounds)area, CardinalPoint.E);
    }

    private void relocateNode(Label node, Bounds area, CardinalPoint cp) {
        double translateY;
        double translateX;
        double rotation;
        assert (node != null);
        double nodeW = node.getPrefWidth();
        double nodeH = node.getPrefHeight();
        double areaW = area.getWidth();
        double areaH = area.getHeight();
        switch (cp) {
            case N: {
                rotation = 0.0;
                translateX = areaW / 2.0;
                translateY = -nodeH / 2.0;
                break;
            }
            case S: {
                rotation = 0.0;
                translateX = areaW / 2.0;
                translateY = areaH + nodeH / 2.0;
                break;
            }
            case W: {
                rotation = -90.0;
                translateX = -nodeH / 2.0;
                translateY = areaH / 2.0;
                break;
            }
            case E: {
                rotation = 90.0;
                translateX = areaW + nodeH / 2.0;
                translateY = areaH / 2.0;
                break;
            }
            default: {
                assert (false);
                translateY = 0.0;
                translateX = 0.0;
                rotation = 0.0;
            }
        }
        double nodeCenterX = nodeW / 2.0;
        double nodeCenterY = nodeH / 2.0;
        double layoutDX = area.getMinX() - nodeCenterX + translateX;
        double layoutDY = area.getMinY() - nodeCenterY + translateY;
        node.setLayoutX(layoutDX);
        node.setLayoutY(layoutDY);
        node.setRotate(rotation);
    }

    private void updateSelection(List<Node> trayChildren, Set<Integer> selectedIndexes) {
        String selectedClass = "selected";
        int count = trayChildren.size();
        for (int i = 0; i < count; ++i) {
            ObservableList trayStyleClasses = trayChildren.get(i).getStyleClass();
            if (selectedIndexes.contains(i)) {
                if (trayStyleClasses.contains("selected")) continue;
                trayStyleClasses.add("selected");
                continue;
            }
            if (!trayStyleClasses.contains("selected")) continue;
            trayStyleClasses.remove("selected");
        }
    }

    private void updateTargetCell() {
        if (this.targetColumnIndex == -1) {
            assert (this.targetRowIndex == -1);
            this.targetCellShadow.setVisible(false);
        } else {
            this.targetCellShadow.setVisible(true);
            Bounds tb = this.getCellBounds(this.targetColumnIndex, this.targetRowIndex);
            this.targetCellShadow.setX(tb.getMinX());
            this.targetCellShadow.setY(tb.getMinY());
            this.targetCellShadow.setWidth(tb.getWidth());
            this.targetCellShadow.setHeight(tb.getHeight());
        }
    }

    private Bounds getCellBounds(int c, int r) {
        int cellIndex = this.getCellIndex(c, r);
        assert (cellIndex < this.cellBounds.size());
        return this.cellBounds.get(cellIndex);
    }

    private int getCellIndex(int c, int r) {
        return c * this.rowCount + r;
    }

    private void updateTargetGap() {
        double strokeWidth;
        double startX;
        if (this.targetGapColumnIndex == -1) {
            this.targetGapShadowV.setVisible(false);
        } else {
            double endY;
            double startY;
            Bounds bottomCellBounds;
            Bounds topCellBounds;
            this.targetGapShadowV.setVisible(true);
            if (this.targetGapColumnIndex < this.columnCount) {
                topCellBounds = this.getCellBounds(this.targetGapColumnIndex, 0);
                bottomCellBounds = this.getCellBounds(this.targetGapColumnIndex, this.rowCount - 1);
                startY = topCellBounds.getMinY();
                endY = bottomCellBounds.getMaxY();
                if (this.targetGapColumnIndex == 0) {
                    startX = topCellBounds.getMinX();
                    strokeWidth = 8.0;
                } else {
                    assert (this.targetGapColumnIndex >= 1);
                    Bounds leftTopCellBounds = this.getCellBounds(this.targetGapColumnIndex - 1, 0);
                    startX = (leftTopCellBounds.getMaxX() + topCellBounds.getMinX()) / 2.0;
                    strokeWidth = Math.abs(leftTopCellBounds.getMaxX() - topCellBounds.getMinX());
                }
            } else {
                topCellBounds = this.getCellBounds(this.columnCount - 1, 0);
                bottomCellBounds = this.getCellBounds(this.columnCount - 1, this.rowCount - 1);
                startX = topCellBounds.getMaxX();
                startY = topCellBounds.getMinY();
                endY = bottomCellBounds.getMaxY();
                strokeWidth = 8.0;
            }
            this.targetGapShadowV.setStartX(startX);
            this.targetGapShadowV.setStartY(startY);
            this.targetGapShadowV.setEndX(startX);
            this.targetGapShadowV.setEndY(endY);
            this.targetGapShadowV.setStrokeWidth(Math.max(strokeWidth, 8.0));
        }
        if (this.targetGapRowIndex == -1) {
            this.targetGapShadowH.setVisible(false);
        } else {
            double startY;
            double endX;
            Bounds rightCellBounds;
            Bounds leftCellBounds;
            this.targetGapShadowH.setVisible(true);
            if (this.targetGapRowIndex < this.rowCount) {
                leftCellBounds = this.getCellBounds(0, this.targetGapRowIndex);
                rightCellBounds = this.getCellBounds(this.columnCount - 1, this.targetGapRowIndex);
                startX = leftCellBounds.getMinX();
                endX = rightCellBounds.getMaxX();
                if (this.targetGapRowIndex == 0) {
                    startY = leftCellBounds.getMinY();
                    strokeWidth = 8.0;
                } else {
                    assert (this.targetGapRowIndex >= 1);
                    Bounds aboveLeftCellBounds = this.getCellBounds(0, this.targetGapRowIndex - 1);
                    startY = (aboveLeftCellBounds.getMaxY() + leftCellBounds.getMinY()) / 2.0;
                    strokeWidth = Math.abs(aboveLeftCellBounds.getMaxY() - leftCellBounds.getMinY());
                }
            } else {
                leftCellBounds = this.getCellBounds(0, this.rowCount - 1);
                rightCellBounds = this.getCellBounds(this.columnCount - 1, this.rowCount - 1);
                startX = leftCellBounds.getMinX();
                endX = rightCellBounds.getMaxX();
                startY = leftCellBounds.getMaxY();
                strokeWidth = 8.0;
            }
            this.targetGapShadowH.setStartX(startX);
            this.targetGapShadowH.setStartY(startY);
            this.targetGapShadowH.setEndX(endX);
            this.targetGapShadowH.setEndY(startY);
            this.targetGapShadowH.setStrokeWidth(Math.max(strokeWidth, 8.0));
        }
    }
}

