/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneMosaic;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.SelectAndMoveInGridGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class GridPanePring
extends AbstractPring<GridPane> {
    private final GridPaneMosaic mosaic = new GridPaneMosaic("pring", true, false);

    public GridPanePring(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, GridPane.class);
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        this.getRootNode().getChildren().add((Object)this.mosaic.getTopGroup());
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        return ((GridPane)this.getSceneGraphObject()).getLayoutBounds();
    }

    @Override
    public Node getSceneGraphObjectProxy() {
        return (Node)this.getSceneGraphObject();
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        this.startListeningToLayoutBounds((Node)this.getSceneGraphObject());
        this.startListeningToLocalToSceneTransform((Node)this.getSceneGraphObject());
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        this.stopListeningToLayoutBounds((Node)this.getSceneGraphObject());
        this.stopListeningToLocalToSceneTransform((Node)this.getSceneGraphObject());
    }

    @Override
    protected void layoutDecoration() {
        if (this.mosaic.getGridPane() != this.getSceneGraphObject()) {
            this.mosaic.setGridPane((GridPane)this.getSceneGraphObject());
        } else {
            this.mosaic.update();
        }
        for (Node node : this.mosaic.getNorthTrayNodes()) {
            this.attachPring(node);
        }
        for (Node node : this.mosaic.getSouthTrayNodes()) {
            this.attachPring(node);
        }
        for (Node node : this.mosaic.getEastTrayNodes()) {
            this.attachPring(node);
        }
        for (Node node : this.mosaic.getWestTrayNodes()) {
            this.attachPring(node);
        }
        this.mosaic.getTopGroup().getTransforms().clear();
        this.mosaic.getTopGroup().getTransforms().add((Object)this.getSceneGraphObjectToDecorationTransform());
    }

    @Override
    public void changeStroke(Paint stroke) {
        assert (stroke instanceof Color);
        this.mosaic.setTrayColor((Color)stroke);
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        GridSelectionGroup.Type feature;
        int trayIndex = this.mosaic.getNorthTrayNodes().indexOf(node);
        if (trayIndex != -1) {
            feature = GridSelectionGroup.Type.COLUMN;
        } else {
            trayIndex = this.mosaic.getSouthTrayNodes().indexOf(node);
            if (trayIndex != -1) {
                feature = GridSelectionGroup.Type.COLUMN;
            } else {
                trayIndex = this.mosaic.getWestTrayNodes().indexOf(node);
                if (trayIndex != -1) {
                    feature = GridSelectionGroup.Type.ROW;
                } else {
                    trayIndex = this.mosaic.getEastTrayNodes().indexOf(node);
                    feature = GridSelectionGroup.Type.ROW;
                }
            }
        }
        SelectAndMoveInGridGesture result = trayIndex == -1 ? null : new SelectAndMoveInGridGesture(this.getContentPanelController(), this.getFxomInstance(), feature, trayIndex);
        return result;
    }

    private void attachPring(Node node) {
        if (AbstractPring.lookupPring(node) == null) {
            GridPanePring.attachPring(node, this);
        }
    }
}

