/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractResilientHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.BoundsUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabHandles
extends AbstractResilientHandles<Tab> {
    private TabPane tabPane;
    private Node tabNode;

    public TabHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Tab.class);
        ((Tab)this.getSceneGraphObject()).tabPaneProperty().addListener((ov, v1, v2) -> this.tabPaneDidChange());
        this.tabPaneDidChange();
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        assert (this.isReady());
        assert (this.tabPane != null);
        if (this.tabNode == null) {
            this.tabNode = this.lookupTabNode();
        }
        Bounds b = this.tabNode.getLayoutBounds();
        Point2D min = Deprecation.localToLocal(this.tabNode, b.getMinX(), b.getMinY(), (Node)this.tabPane);
        Point2D max = Deprecation.localToLocal(this.tabNode, b.getMaxX(), b.getMaxY(), (Node)this.tabPane);
        return BoundsUtils.makeBounds(min, max);
    }

    @Override
    public Node getSceneGraphObjectProxy() {
        assert (this.isReady());
        assert (this.tabPane != null);
        return this.tabPane;
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tabPane != null);
        if (this.tabNode == null) {
            this.tabNode = this.lookupTabNode();
        }
        this.startListeningToLayoutBounds((Node)this.tabPane);
        this.startListeningToLocalToSceneTransform((Node)this.tabPane);
        this.startListeningToBoundsInParent(this.tabNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        assert (this.isReady());
        assert (this.tabPane != null);
        this.stopListeningToLayoutBounds((Node)this.tabPane);
        this.stopListeningToLocalToSceneTransform((Node)this.tabPane);
        this.stopListeningToBoundsInParent(this.tabNode);
    }

    private void tabPaneDidChange() {
        this.tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.setReady(this.tabPane != null);
    }

    private Node lookupTabNode() {
        assert (this.tabPane != null);
        TabPaneDesignInfoX di = new TabPaneDesignInfoX();
        return di.getTabNode(this.tabPane, (Tab)this.getSceneGraphObject());
    }
}

