/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TreeTableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;

public class TreeTableColumnResizer {
    private static final PropertyName minWidthName = new PropertyName("minWidth");
    private static final PropertyName prefWidthName = new PropertyName("prefWidth");
    private static final PropertyName maxWidthName = new PropertyName("maxWidth");
    private final TreeTableColumn<?, ?> treeTableColumn;
    private final TreeTableColumn<?, ?> treeTableColumnNext;
    private final ColumnSizing originalSizing;
    private final ColumnSizing originalSizingNext;
    private final double x1;
    private final double x2;
    private final double x3;

    public TreeTableColumnResizer(TreeTableColumn<?, ?> treeTableColumn) {
        assert (treeTableColumn != null);
        assert (treeTableColumn.getTreeTableView() != null);
        this.treeTableColumn = treeTableColumn;
        this.originalSizing = new ColumnSizing(this.treeTableColumn);
        ObservableList columns = this.treeTableColumn.getParentColumn() != null ? this.treeTableColumn.getParentColumn().getColumns() : this.treeTableColumn.getTreeTableView().getColumns();
        int columnIndex = columns.indexOf(this.treeTableColumn);
        if (columnIndex + 1 < columns.size()) {
            this.treeTableColumnNext = (TreeTableColumn)columns.get(columnIndex + 1);
            this.originalSizingNext = new ColumnSizing(this.treeTableColumnNext);
        } else {
            this.treeTableColumnNext = null;
            this.originalSizingNext = null;
        }
        TreeTableViewDesignInfoX di = new TreeTableViewDesignInfoX();
        Bounds columnBounds = di.getColumnBounds(treeTableColumn);
        this.x1 = columnBounds.getMinX();
        this.x2 = columnBounds.getMaxX();
        if (this.treeTableColumnNext != null) {
            Bounds nextBounds = di.getColumnBounds(this.treeTableColumnNext);
            this.x3 = nextBounds.getMaxX();
        } else if (treeTableColumn.getParentColumn() != null) {
            TableColumnBase parentColumn = this.treeTableColumn.getParentColumn();
            assert (parentColumn instanceof TreeTableColumn);
            Bounds parentBounds = di.getColumnBounds((TreeTableColumn)parentColumn);
            this.x3 = parentBounds.getMaxX();
        } else {
            Bounds layoutBounds = treeTableColumn.getTreeTableView().getLayoutBounds();
            this.x3 = layoutBounds.getMaxX();
        }
    }

    public TreeTableColumn<?, ?> getTreeTableColumn() {
        return this.treeTableColumn;
    }

    public void updateWidth(double dx) {
        double newX2 = Math.max(this.x1, Math.min(this.x3, this.x2 + dx));
        double newWidth = newX2 - this.x1;
        double newWidthNext = this.x3 - newX2;
        this.treeTableColumn.setPrefWidth(newWidth);
        if (this.treeTableColumn.getMinWidth() == -1.0) {
            this.treeTableColumn.setMinWidth(newWidth);
        } else {
            this.treeTableColumn.setMinWidth(Math.min(newWidth, this.treeTableColumn.getMinWidth()));
        }
        if (this.treeTableColumn.getMaxWidth() == -1.0) {
            this.treeTableColumn.setMaxWidth(newWidth);
        } else {
            this.treeTableColumn.setMaxWidth(Math.max(newWidth, this.treeTableColumn.getMaxWidth()));
        }
        if (this.treeTableColumnNext != null) {
            this.treeTableColumnNext.setPrefWidth(newWidthNext);
            if (this.treeTableColumnNext.getMinWidth() == -1.0) {
                this.treeTableColumnNext.setMinWidth(newWidthNext);
            } else {
                this.treeTableColumnNext.setMinWidth(Math.min(newWidthNext, this.treeTableColumnNext.getMinWidth()));
            }
            if (this.treeTableColumnNext.getMaxWidth() == -1.0) {
                this.treeTableColumnNext.setMaxWidth(newWidthNext);
            } else {
                this.treeTableColumnNext.setMaxWidth(Math.max(newWidthNext, this.treeTableColumnNext.getMaxWidth()));
            }
        }
    }

    public void revertToOriginalSize() {
        this.originalSizing.applyTo(this.treeTableColumn);
        if (this.treeTableColumnNext != null) {
            this.originalSizingNext.applyTo(this.treeTableColumnNext);
        }
    }

    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(this.treeTableColumn.getMinWidth(), this.originalSizing.getMinWidth())) {
            result.put(minWidthName, this.treeTableColumn.getMinWidth());
        }
        if (!MathUtils.equals(this.treeTableColumn.getPrefWidth(), this.originalSizing.getPrefWidth())) {
            result.put(prefWidthName, this.treeTableColumn.getPrefWidth());
        }
        if (!MathUtils.equals(this.treeTableColumn.getMaxWidth(), this.originalSizing.getMaxWidth())) {
            result.put(maxWidthName, this.treeTableColumn.getMaxWidth());
        }
        return result;
    }

    public Map<PropertyName, Object> getChangeMapNext() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (this.treeTableColumnNext != null) {
            if (!MathUtils.equals(this.treeTableColumnNext.getMinWidth(), this.originalSizingNext.getMinWidth())) {
                result.put(minWidthName, this.treeTableColumnNext.getMinWidth());
            }
            if (!MathUtils.equals(this.treeTableColumnNext.getPrefWidth(), this.originalSizingNext.getPrefWidth())) {
                result.put(prefWidthName, this.treeTableColumnNext.getPrefWidth());
            }
            if (!MathUtils.equals(this.treeTableColumnNext.getMaxWidth(), this.originalSizingNext.getMaxWidth())) {
                result.put(maxWidthName, this.treeTableColumnNext.getMaxWidth());
            }
        }
        return result;
    }

    private static class ColumnSizing {
        private final double minWidth;
        private final double maxWidth;
        private final double prefWidth;

        public ColumnSizing(TreeTableColumn<?, ?> tc) {
            this.minWidth = tc.getMinWidth();
            this.maxWidth = tc.getMaxWidth();
            this.prefWidth = tc.getPrefWidth();
        }

        public double getMinWidth() {
            return this.minWidth;
        }

        public double getMaxWidth() {
            return this.maxWidth;
        }

        public double getPrefWidth() {
            return this.prefWidth;
        }

        public void applyTo(TreeTableColumn<?, ?> tc) {
            tc.setMinWidth(this.minWidth);
            tc.setMaxWidth(this.maxWidth);
            tc.setPrefWidth(this.prefWidth);
        }
    }
}

