/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public class DividerPositionsEditor
extends PropertyEditor {
    private final VBox vbox = new VBox(5.0);

    public DividerPositionsEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_TOP);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.vbox);
    }

    @Override
    public Object getValue() {
        Double[] values = new Double[this.getDoubleFields().size()];
        int index = 0;
        for (Node node : this.getDoubleFields()) {
            assert (node instanceof DoubleField);
            DoubleField doubleField = (DoubleField)node;
            String val = doubleField.getText();
            if (val.isEmpty()) {
                val = "0";
                doubleField.setText(val);
            } else {
                try {
                    Double.parseDouble(val);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            values[index] = Double.valueOf(val);
            ++index;
        }
        return Arrays.asList(values);
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value != null);
        assert (value instanceof List);
        List doubleList = (List)value;
        ArrayList<Double> roundedValues = new ArrayList<Double>();
        Iterator iterator = doubleList.iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            roundedValues.add(EditorUtils.round(val, 10000));
        }
        this.fillVBox(roundedValues);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.vbox.getChildren().clear();
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_TOP);
    }

    @Override
    protected void valueIsIndeterminate() {
        ArrayList<Double> value = new ArrayList<Double>();
        value.add(0.0);
        this.fillVBox(value);
        DividerPositionsEditor.handleIndeterminate(this.getDoubleFields().get(0));
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.getDoubleFields().get(0).requestFocus());
    }

    private void fillVBox(List<Double> values) {
        this.vbox.getChildren().clear();
        for (Double value : values) {
            double val = value != null ? value : 0.0;
            DoubleField doubleField = new DoubleField();
            doubleField.setText(EditorUtils.valAsStr(val));
            this.vbox.getChildren().add((Object)doubleField);
            EventHandler valueListener = event -> this.userUpdateValueProperty(this.getValue());
            this.setNumericEditorBehavior(this, (Control)doubleField, (EventHandler<ActionEvent>)valueListener, false);
        }
    }

    private List<Node> getDoubleFields() {
        return this.vbox.getChildren();
    }
}

