/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.CustomRepositoryListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.RepositoryListItem;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class RepositoryManagerListCell
extends ListCell<RepositoryListItem> {
    private RepositoryListItem listItem;

    public void updateItem(RepositoryListItem item, boolean empty) {
        this.listItem = item;
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setPrefWidth(0.0);
            this.setGraphic((Node)this.createCellContent());
        }
    }

    private HBox createCellContent() {
        HBox cellContent = new HBox();
        cellContent.setAlignment(Pos.CENTER_LEFT);
        String name = this.listItem.getRepository().getId();
        Label fileName = new Label(name);
        fileName.setTooltip(new Tooltip(name + " [" + this.listItem.getRepository().getURL() + "]"));
        HBox.setHgrow((Node)fileName, (Priority)Priority.ALWAYS);
        HBox buttonContent = this.createButtonCellContent();
        HBox.setHgrow((Node)buttonContent, (Priority)Priority.ALWAYS);
        cellContent.getChildren().addAll((Object[])new Node[]{fileName, buttonContent});
        return cellContent;
    }

    private HBox createButtonCellContent() {
        HBox buttonContent = new HBox();
        buttonContent.setAlignment(Pos.CENTER_RIGHT);
        buttonContent.setSpacing(5.0);
        if (this.listItem instanceof CustomRepositoryListItem) {
            Button editButton = new Button("", (Node)new ImageView(ImageUtils.getEditIconImage()));
            editButton.getStyleClass().add((Object)"image-view-button");
            editButton.setOnMouseClicked(event -> this.listItem.getRepositoryManagerController().edit(this.listItem));
            editButton.setTooltip(new Tooltip(I18N.getString("repository.manager.button.edit.tooltip")));
            Button deleteButton = new Button("", (Node)new ImageView(ImageUtils.getDeleteIconImage()));
            deleteButton.setOnMouseClicked(event -> this.listItem.getRepositoryManagerController().delete(this.listItem));
            deleteButton.getStyleClass().add((Object)"image-view-button");
            deleteButton.setTooltip(new Tooltip(I18N.getString("repository.manager.button.delete.tooltip")));
            buttonContent.getChildren().addAll((Object[])new Node[]{editButton, deleteButton});
        }
        return buttonContent;
    }
}

