/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.aether.artifact.DefaultArtifact;

public class NexusSearch
implements Search {
    private static final String URL_PREFIX = "/service/local/data_index?q=";
    private static final String URL_PREFIX_CLASS = "http://nexus.gluonhq.com/nexus/service/local/data_index?cn=";
    private static final String URL_SUFFIX = "&from=";
    private final HttpClient client = HttpClients.createDefault();
    private final String name;
    private final String domain;
    private final String username;
    private final String password;
    private static boolean first;
    private static int iteration;
    private int totalCount = 0;
    private static final int ITEMS_ITERATION = 200;
    private static final int MAX_RESULTS = 2000;

    public NexusSearch(String name, String domain, String username, String password) {
        this.name = name;
        this.domain = domain;
        this.username = username;
        this.password = password;
        iteration = 0;
        first = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        try {
            HttpGet request = new HttpGet(this.domain + URL_PREFIX + query + (first ? "" : URL_SUFFIX + iteration * 200));
            if (!this.username.isEmpty() && !this.password.isEmpty()) {
                String authStringEnc = new String(Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes()));
                request.addHeader("Authorization", "Basic " + authStringEnc);
            }
            request.setHeader("Accept", "application/json");
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            try (JsonReader rdr = Json.createReader((InputStream)response.getEntity().getContent());){
                JsonObject obj = rdr.readObject();
                if (first && obj != null && !obj.isEmpty() && obj.containsKey((Object)"totalCount")) {
                    first = false;
                    this.totalCount = Math.min(obj.getInt("totalCount", 0), 2000);
                    if (this.totalCount > 200) {
                        ArrayList<DefaultArtifact> coordinates = new ArrayList<DefaultArtifact>(this.processRequest(obj));
                        while (true) {
                            if (this.totalCount <= 200) {
                                ArrayList<DefaultArtifact> arrayList = coordinates;
                                return arrayList;
                            }
                            ++iteration;
                            coordinates.addAll(this.getCoordinates(query).stream().filter(ga -> coordinates.stream().noneMatch(ar -> ar.getGroupId().equals(ga.getGroupId()) && ar.getArtifactId().equals(ga.getArtifactId()))).collect(Collectors.toList()));
                            this.totalCount -= 200;
                        }
                    }
                }
                List<DefaultArtifact> list = this.processRequest(obj);
                return list;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NexusSearch.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private List<DefaultArtifact> processRequest(JsonObject obj) {
        if (obj != null && !obj.isEmpty() && obj.containsKey((Object)"data")) {
            JsonArray docResults = obj.getJsonArray("data");
            return docResults.getValuesAs(JsonObject.class).stream().map(doc -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Repository", this.name + " (" + doc.getString("repoId", "") + ")");
                return new DefaultArtifact(doc.getString("groupId", "") + ":" + doc.getString("artifactId", "") + ":" + "[0,)", map);
            }).distinct().collect(Collectors.toList());
        }
        return null;
    }
}

