/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractPanelController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;

public abstract class AbstractFxmlPanelController
extends AbstractPanelController {
    private final URL fxmlURL;
    private final ResourceBundle resources;

    protected AbstractFxmlPanelController(URL fxmlURL, ResourceBundle resources, EditorController editorController) {
        super(editorController);
        this.fxmlURL = fxmlURL;
        this.resources = resources;
        assert (fxmlURL != null) : "Check the name of the FXML file used by " + this.getClass().getSimpleName();
    }

    @Override
    protected void makePanel() {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.fxmlURL);
        loader.setResources(this.resources);
        try {
            this.setPanelRoot((Parent)loader.load());
            this.controllerDidLoadFxml();
        }
        catch (IOException | RuntimeException x) {
            System.out.println("loader.getController()=" + loader.getController());
            System.out.println("loader.getLocation()=" + loader.getLocation());
            throw new RuntimeException("Failed to load " + this.fxmlURL.getFile(), x);
        }
    }

    protected abstract void controllerDidLoadFxml();
}

