/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractWindowController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.stage.Window;

public abstract class AbstractFxmlWindowController
extends AbstractWindowController {
    private final URL fxmlURL;
    private final ResourceBundle resources;

    public AbstractFxmlWindowController(URL fxmlURL) {
        this(fxmlURL, null);
    }

    public AbstractFxmlWindowController(URL fxmlURL, ResourceBundle resources) {
        this(fxmlURL, resources, null);
    }

    public AbstractFxmlWindowController(URL fxmlURL, ResourceBundle resources, boolean sizeToScene) {
        this(fxmlURL, resources, null, sizeToScene);
    }

    public AbstractFxmlWindowController(URL fxmlURL, ResourceBundle resources, Window owner) {
        super(owner);
        assert (fxmlURL != null) : "Check fxml path given to " + this.getClass().getSimpleName();
        this.fxmlURL = fxmlURL;
        this.resources = resources;
    }

    public AbstractFxmlWindowController(URL fxmlURL, ResourceBundle resources, Window owner, boolean sizeToScene) {
        super(owner, sizeToScene);
        assert (fxmlURL != null) : "Check fxml path given to " + this.getClass().getSimpleName();
        this.fxmlURL = fxmlURL;
        this.resources = resources;
    }

    public URL getFXMLURL() {
        return this.fxmlURL;
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    protected void controllerDidLoadFxml() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() == null);
    }

    @Override
    protected void makeRoot() {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.fxmlURL);
        loader.setResources(this.resources);
        try {
            this.setRoot((Parent)((Region)loader.load()));
            this.controllerDidLoadFxml();
        }
        catch (IOException | RuntimeException x) {
            System.out.println("loader.getController()=" + loader.getController());
            System.out.println("loader.getLocation()=" + loader.getLocation());
            throw new RuntimeException("Failed to load " + this.fxmlURL.getFile(), x);
        }
    }
}

