/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FXOMFxIdMerger {
    private final Set<String> existingFxIds = new HashSet<String>();
    private final Map<String, String> renamings;

    public FXOMFxIdMerger(Collection<String> existingFxIds, Collection<String> importedFxIds) {
        assert (existingFxIds != null);
        assert (importedFxIds != null);
        this.existingFxIds.addAll(existingFxIds);
        this.renamings = this.makeRenamings(importedFxIds);
    }

    public String getRenamedFxId(String importedFxId) {
        return this.renamings.get(importedFxId);
    }

    private Map<String, String> makeRenamings(Collection<String> importedFxIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> currentFxIds = new HashSet<String>();
        currentFxIds.addAll(this.existingFxIds);
        currentFxIds.removeAll(importedFxIds);
        HashSet<String> newFxIds = new HashSet<String>();
        newFxIds.addAll(importedFxIds);
        newFxIds.removeAll(this.existingFxIds);
        HashSet<String> conflictingFxIds = new HashSet<String>();
        conflictingFxIds.addAll(this.existingFxIds);
        conflictingFxIds.retainAll(importedFxIds);
        for (String fxId : newFxIds) {
            result.put(fxId, fxId);
        }
        if (!conflictingFxIds.isEmpty()) {
            HashSet<String> nameSpace = new HashSet<String>();
            nameSpace.addAll(currentFxIds);
            nameSpace.addAll(newFxIds);
            for (String fxId : conflictingFxIds) {
                String renamedFxId = this.generateFxId(fxId, nameSpace);
                result.put(fxId, renamedFxId);
                nameSpace.add(renamedFxId);
            }
        }
        return result;
    }

    private String generateFxId(String conflictFxId, Set<String> nameSpace) {
        assert (conflictFxId != null);
        assert (nameSpace != null);
        assert (!nameSpace.contains(conflictFxId));
        int suffix = 1;
        int conflictFxIdLength = conflictFxId.length();
        StringBuilder sb = new StringBuilder();
        sb.append(conflictFxId);
        sb.append(suffix);
        while (nameSpace.contains(sb.toString())) {
            sb.delete(conflictFxIdLength, sb.length());
            sb.append(++suffix);
        }
        return sb.toString();
    }
}

